package com.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {
	
	public static final void main(String[] args) throws Exception {
		go(args[0], Integer.parseInt(args[1]));
	}
	
	protected static final void go(String drl, int count) throws Exception {
		// load up the knowledge base
		KnowledgeBase kbase = readKnowledgeBase(drl);
		StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
		AtomicInteger barCount = new AtomicInteger();
		AtomicInteger fooCount = new AtomicInteger();
		ksession.setGlobal("barCount", barCount);
		ksession.setGlobal("fooCount", fooCount);
		// go !
		List<Foo> foos = new ArrayList<Foo>(count);
		List<Bar> bars = new ArrayList<Bar>(count);
		for(int i = 0; i < count; i++) {
			foos.add(new Foo());
			bars.add(new Bar());
		}
		Random rnd = new Random();
		for(int i = 0; i < count; i++) {
			foos.get(rnd.nextInt(count)).setBar(bars.get(rnd.nextInt(count)));
			bars.get(rnd.nextInt(count)).setFoo(foos.get(rnd.nextInt(count)));
		}
		long time = System.currentTimeMillis();
		for(int i = 0; i < count; i++) {
			ksession.insert(foos.get(i));
			ksession.insert(bars.get(i));
		}
		ksession.fireAllRules();
		long duration = (System.currentTimeMillis() - time);

		System.out.println(drl + " Count: " + count);
		System.out.println(drl + " Time: " + duration + "ms");
		System.out.println(drl + " Time per element: " + ((double)duration/count) + "ms");
		System.out.println("BAR Duplicates: " + barCount.get());
		System.out.println("FOO Duplicates: " + fooCount.get());
		System.out.println();
	}

	private static KnowledgeBase readKnowledgeBase(String name) throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource(name), ResourceType.DRL);
		KnowledgeBuilderErrors errors = kbuilder.getErrors();
		if (errors.size() > 0) {
			for (KnowledgeBuilderError error: errors) {
				System.err.println(error);
			}
			throw new IllegalArgumentException("Could not parse knowledge.");
		}
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		return kbase;
	}

	public static class Foo {

		public Bar bar;

		public Bar getBar() {
			return this.bar;
		}

		public void setBar(Bar bar) {
			this.bar = bar;
		}
		
	}

	public static class Bar {

		public Foo foo;

		public Foo getFoo() {
			return this.foo;
		}

		public void setFoo(Foo foo) {
			this.foo = foo;
		}
		
	}

}