package test;


import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;

import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;

public class TestThreads {

    public static RuleBase rulebase;
    
    public static void main(String[] args) {
        PackageBuilderConfiguration pkgBuilderCfg =
            new PackageBuilderConfiguration();
        PackageBuilder builder = new PackageBuilder(pkgBuilderCfg);
        try {
            builder.addPackageFromDrl(new InputStreamReader(TestThreads.class.getResourceAsStream( "Sample.drl" )));
        } catch (DroolsParserException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        rulebase = RuleBaseFactory.newRuleBase();
        try {
            rulebase.addPackage(builder.getPackage());
        } catch (Exception e) {
            e.printStackTrace();
        }
        for(int i = 0; i<100 ; i++) {
            DroolsThread tt = new DroolsThread("Thread " + i);
            new Thread(tt).start();
        }
    }
    
    public static class Fact {
        public String s;

        public Fact(String s){
            this.s = s; 
        }

        public String getS() {
            return s;
        }
    }

    public static class DroolsThread implements Runnable {

        private String id;

        public DroolsThread(String id) {
            this.id = id;
        }

        public void run() {
            StatefulSession session = rulebase.newStatefulSession();
            for(int i = 0; i < 100; i++) {
                session.insert(new Fact(id));
            }
        }
    }
}
