package com.poferries.common.rules.api;

/**
 * Generic Class implementing RuleViolation.
 * @see {@link RuleViolation}
 * @author Sarath
 *
 */
public class GenericRuleViolation implements RuleViolation {
	
	/**
	 * Instance variable to store the violating object.
	 */
	private Object fact;
	
	/**
	 * Description about the violation.
	 */
	private String description;
	
	/**
	 * 
	 * @param fact
	 * @param description
	 */
	public GenericRuleViolation(Object fact, String description) {
		super();
		this.fact = fact;
		this.description = description;
	}
	
	/**
	 * 
	 * @see com.poferries.common.rules.api.RuleViolation#getDescription()
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 
	 * @see com.poferries.common.rules.api.RuleViolation#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 
	 * @see com.poferries.common.rules.api.RuleViolation#getFact()
	 */
	public Object getFact() {
		return fact;
	}

	/**
	 * 
	 * @see com.poferries.common.rules.api.RuleViolation#setFact(java.lang.Object)
	 */
	public void setFact(Object fact) {
		this.fact = fact;
	}
	
	
	
	
}
