package com.poferries.common.rules.api;

/**
 * This exception will be thrown when A RuleBase or packge can't 
 * be created from the data stored in the DB.
 * 
 * @see {@link RuleBaseManager#getRuleBase(String)}
 * 
 * @author Sarath 
 *
 */
public class InvalidPackageException extends RuntimeException {
	
	/**
	 * Serialization VersionID of this class
	 */
	private static final long serialVersionUID = 1L;

	public InvalidPackageException(Throwable throwable) {
		super("Invalid rule package.",throwable);
	}
	/**
	 * create Invalid package Runtime Exception
	 */
	public InvalidPackageException() {
		super("Invalid rule package.");
	}
	
}
