/*
 *================================================================
 * Author SVN          : $LastChangedBy$
 * Last Update         : $LastChangedDate$
 * Copyright           : P&O Ferries  
 * 						(subject to the Terms and Conditions of the 
 * 						 Master Services Agreement between P&O Ferries 
 * 						 and Sapient, dated 10 July 2007)
 * SVN URL             : $HeadURL$
 * AllChange Version   : $ACversion$
 *================================================================
 */
package com.poferries.common.rules.api;

import java.rmi.RemoteException;
import java.util.Calendar;

import org.drools.RuleBase;

/**
 * Wraps the org.drools.rules.RuleBase objects, it's management and operation.
 * 
 * @author Sarath
 * 
 */
public interface RuleBaseManager {

	/**
	 * Creates an instance of RuleBase from the serialized package data.
	 * 
	 * @param packageName
	 *            Name of the package.
	 * 
	 * @return instance of the RuleBase.
	 * 
	 * @throws InvalidPackageException
	 *             when,
	 *             <ol>
	 *             <li> {@link org.drools.rule.Package} can't be created from
	 *             the binary data in the database.</li>
	 * 
	 * <li>Binary data for the package specified by package name doesn't
	 * exists.</li>
	 * <li>Can't create RuleBase Object for package name.</li>
	 * </ul
	 */
	public RuleBase getRuleBase(final String packageName)
			throws InvalidPackageException;

	/**
	 * saves the rulebase package data in database.
	 * 
	 * @param packageName
	 *            Name of the package.
	 * @param packageData
	 *            Binary data of the package.
	 * @param validFrom
	 *            Time from which the rule is valid.
	 * 
	 * @return boolean The status whether the rulebase package is saved in
	 *         database.
	 * 
	 * @throws Exception
	 *             when package is not saved in database.
	 */
	public boolean createRuleBase(final String packageName,
			final byte[] packageData, final Calendar validFrom)
			throws RemoteException;

}
