/*
 *================================================================
 * Author SVN          : $LastChangedBy$
 * Last Update         : $LastChangedDate$
 * Copyright           : P&O Ferries  
 * 						(subject to the Terms and Conditions of the 
 * 						 Master Services Agreement between P&O Ferries 
 * 						 and Sapient, dated 10 July 2007)
 * SVN URL             : $HeadURL$
 * AllChange Version   : $ACversion$
 *================================================================
 */
package com.poferries.common.rules.api;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.Calendar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.rule.Package;

import com.poferries.ruledataservice.wsdl.RuleDataService_Factory;
import com.poferries.ruledataservice.wsdl.RuleDataService_PortType;
import com.poferries.ruledataservice.xsd.CreateRulePackageRequest_Type;
import com.poferries.ruledataservice.xsd.CreateRulePackageResponse_Type;
import com.poferries.ruledataservice.xsd.GetRulePackageRequest_Type;
import com.poferries.ruledataservice.xsd.GetRulePackageResponse_Type;

/**
 * Wraps the org.drools.rules.RuleBase objects, it's management and operation.
 * 
 * @author Sarath
 * 
 */
public class RuleBaseManagerImpl implements RuleBaseManager {

	private static final Log LOG = LogFactory.getLog(RuleBaseManager.class);

	/**
	 * The package name used for testing.
	 */
	private static String PACKAGE_NAME = "com.poferries.rules.test";

	/**
	 * The binary .pkg file for testing.
	 */
	private static String RULES_PKG_FILENAME = "test/RuleBaseManagerImplTest.pkg";

	/**
	 * ruleDataService_PortType for {@link RuleDataService_PortType} which will
	 * be used to create the stub for the RulesDataService.
	 */
	RuleDataService_PortType ruleDataService_PortType = null;
	
	/**
	 * @see {@link RuleBaseManager#getRuleBase(String)
	 */
	public RuleBase getRuleBase(final String packageName) {
		try {
			ruleDataService_PortType = RuleDataService_Factory.create();
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		GetRulePackageRequest_Type rulePackageRequest_Type = new GetRulePackageRequest_Type();
		GetRulePackageResponse_Type rulePackageResponse_Type = new GetRulePackageResponse_Type();
		rulePackageRequest_Type.setPackageName(packageName);
		try {
			rulePackageResponse_Type = ruleDataService_PortType
					.getRulePackage(rulePackageRequest_Type);
		} catch (RemoteException remoteException) {
			remoteException.printStackTrace();
		}

		final byte[] pkgData = rulePackageResponse_Type.getData();
		RuleBase ruleBase = null;
		try {

/*			//InputStream objIn = new ByteArrayInputStream(Base64.decode(new String(pkgData)));
			InputStream objIn = new ByteArrayInputStream(pkgData);
			DroolsObjectInputStream droolsObjectInputStream = new DroolsObjectInputStream(
					objIn);
			Package pkg = (Package)droolsObjectInputStream.readObject();
			ruleBase = (RuleBase) droolsObjectInputStream.readObject();						
			ruleBase = droolsObjectInputStream.getRuleBase();*/
			
			final ObjectInputStream objIn=new ObjectInputStream(new ByteArrayInputStream(pkgData));
			final Package pkg=(Package)objIn.readObject();
			pkg.checkValidity();
			ruleBase=RuleBaseFactory.newRuleBase();
			ruleBase.addPackage(pkg);
		} catch (Throwable e) {
			throw new InvalidPackageException(e);
		}

		return ruleBase;
	}

	/**
	 * @see {@link RuleBaseManager#createRuleBase(String, byte[], Calendar)
	 */
	public boolean createRuleBase(final String packageName,
			final byte[] packageData, final Calendar validFrom)
			throws RemoteException {
		CreateRulePackageRequest_Type createRulePackageRequest_Type = new CreateRulePackageRequest_Type();
		CreateRulePackageResponse_Type createRulePackageResponse_Type = new CreateRulePackageResponse_Type();
		createRulePackageRequest_Type.setPackageName(packageName);
		//createRulePackageRequest_Type.setPackageData(Base64.encode(packageData).getBytes());
		createRulePackageRequest_Type.setPackageData(packageData);
		createRulePackageRequest_Type.setValidFrom(validFrom);
		try {
			ruleDataService_PortType = RuleDataService_Factory.create();
		} catch (Exception exception) {
			exception.printStackTrace();
		}

		createRulePackageResponse_Type = ruleDataService_PortType
				.createRulePackage(createRulePackageRequest_Type);
		return createRulePackageResponse_Type.getStatus();
	}

}
