package com.poferries.common.rules.api;

/**
 * This is a marker interface representing a rule violation. This will be 
 * instantiated inside the rules, and returned to the caller as a List. 
 * The core rules API provides a Generic implementation. Callers provide 
 * any other implementation if required.
 * 
 * @author Sarath
 *
 */
public interface RuleViolation {
	
	
	/**
	 * The description about this violation.
	 * @return
	 */
	public String getDescription() ;
	
	/**
	 * Sets the description about this violation.
	 * @param description
	 */
	public void setDescription(String description); 

	/**
	 * The fact that created this violation.
	 * @return
	 */
	public Object getFact() ;

	/**
	 * Sets the fact that created the violation.
	 * @param facts
	 */
	public void setFact(Object facts) ;	
	
}
