package com.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

	private static final int COUNT = 100;
	
	public static final void main(String[] args) {
		try {
			// load up the knowledge base
			KnowledgeBase kbase = readKnowledgeBase(args[0]);
			StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
			AtomicInteger barCount = new AtomicInteger();
			AtomicInteger fooCount = new AtomicInteger();
			ksession.setGlobal("barCount", barCount);
			ksession.setGlobal("fooCount", fooCount);
			// go !
			List<Foo> foos = new ArrayList<Foo>(COUNT);
			List<Bar> bars = new ArrayList<Bar>(COUNT);
			for(int i = 0; i < COUNT; i++) {
				foos.add(new Foo());
				bars.add(new Bar());
			}
			Random rnd = new Random();
			for(int i = 0; i < COUNT; i++) {
				foos.get(rnd.nextInt(COUNT)).setBar(bars.get(rnd.nextInt(COUNT)));
				bars.get(rnd.nextInt(COUNT)).setFoo(foos.get(rnd.nextInt(COUNT)));
			}
			long time = System.currentTimeMillis();
			for(int i = 0; i < COUNT; i++) {
				ksession.insert(foos.get(i));
				ksession.insert(bars.get(i));
			}
			ksession.fireAllRules();
			System.out.println("Time: " + (System.currentTimeMillis() - time) + "ms");
			System.out.println("BAR Duplicates: " + barCount.get());
			System.out.println("FOO Duplicates: " + fooCount.get());
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	private static KnowledgeBase readKnowledgeBase(String name) throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource(name), ResourceType.DRL);
		KnowledgeBuilderErrors errors = kbuilder.getErrors();
		if (errors.size() > 0) {
			for (KnowledgeBuilderError error: errors) {
				System.err.println(error);
			}
			throw new IllegalArgumentException("Could not parse knowledge.");
		}
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		return kbase;
	}

	public static class Foo {

		public Bar bar;

		public Bar getBar() {
			return this.bar;
		}

		public void setBar(Bar bar) {
			this.bar = bar;
		}
		
	}

	public static class Bar {

		public Foo foo;

		public Foo getFoo() {
			return this.foo;
		}

		public void setFoo(Foo foo) {
			this.foo = foo;
		}
		
	}

}