import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatelessKnowledgeSession;

import test.Message;

public class TestDrive {

	public static void main(String[] args) throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource("test/rule.drl"),ResourceType.DRL);
		if (kbuilder.hasErrors()) {
			throw new Exception(kbuilder.getErrors().toString());
		}

		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		
		StatelessKnowledgeSession session = kbase.newStatelessKnowledgeSession();
		
		Message testMessage = new Message();
		testMessage.setMessage("Hello");
		
		session.execute(testMessage);
	}

}
