/*
 * Decompiled with CFR 0.152.
 */
package James;

import James.HandleConnection;
import James.Server;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ServerGUI
extends JFrame
implements ActionListener {
    private JTextArea screen;
    private JButton stop;
    private Color c1;
    private Color c2;
    private JPanel button;
    private JFrame frame;
    private ConcurrentHashMap<InetAddress, HandleConnection> map = new ConcurrentHashMap();
    private boolean containsIPaddress;
    private HandleConnection handle;
    private Server server;

    public ServerGUI(Server server) {
        this.server = server;
        this.frame = new JFrame("Server GUI");
        this.frame.setDefaultCloseOperation(0);
        this.screen = new JTextArea();
        this.screen.setEditable(false);
        this.c1 = new Color(65280);
        this.c2 = new Color(0xFF0000);
        this.screen.setBackground(this.c1);
        this.screen.setFont(new Font("Arial", 1, 26));
        this.screen.setText("No Alarms");
        this.stop = new JButton("Stop");
        this.stop.addActionListener((ActionListener)this);
        this.button = new JPanel();
        this.button.add(this.stop);
        this.frame.add((Component)this.screen, "Center");
        this.frame.add((Component)this.button, "South");
        this.frame.setSize(400, 300);
        this.frame.setVisible(true);
    }

    public synchronized void setColor(Color col) {
        System.out.println("Color: " + col);
        this.screen.setBackground(col);
    }

    public synchronized void setText(String text) {
        this.screen.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Stop")) {
            this.stop();
        }
    }

    public synchronized boolean checkIPAddress(InetAddress i, HandleConnection h) {
        this.handle = h;
        this.containsIPaddress = this.map.containsKey(i);
        if (!this.containsIPaddress) {
            this.map.put(i, this.handle);
        }
        return this.containsIPaddress;
    }

    public synchronized void setHandle(InetAddress i, HandleConnection h) {
        this.containsIPaddress = this.map.containsKey(i);
        if (this.containsIPaddress) {
            this.map.replace(i, null, h);
        }
    }

    private void stop() {
        Enumeration e = this.map.elements();
        while (e.hasMoreElements()) {
            HandleConnection c = (HandleConnection)e.nextElement();
            c.setRunning(false);
            c.writeCommand("<Run>0</Run>");
            c.writeCommand("END");
        }
        this.server.setRunning(false);
    }
}

