package com.sample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.IdentityHashMap;
import java.util.Set;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {
	
	public static final void main(String[] args) throws Exception {
		go(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
	}
	
	protected static final void go(int numBatches, int numA, int numB) throws Exception {
		// load up the knowledge base
		KnowledgeBase kbase = readKnowledgeBase("rules.drl");
		final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
		
		Thread fireThread = new Thread(
			new Runnable() {
				@Override
				public void run() {
					ksession.fireUntilHalt();
				}
			}
		);
		fireThread.setDaemon(true);
		fireThread.start();
		
		Thread.sleep(1000);
		
		List<Latch> batches = new ArrayList<Latch>(numBatches);
		
		for(int i = 0; i < numBatches; i++) {
			
			Latch batch = new Latch("Data " + i);
			batches.add(batch);
			
			List<Object> data = new ArrayList<Object>(numA + numB);
			
			for(int j = 0; j < numA; j++) {
				A a = new A();
				batch.dataSet.add(a);
				data.add(a);
			}
			for(int j = 0; j < numB; j++) {
				B b = new B();
				batch.dataSet.add(b);
				data.add(b);
			}
			
			Collections.shuffle(data);
			
			for(Object o : data) {
				ksession.insert(o);
			}
		}
		
		Collections.shuffle(batches);
		
		for(Latch batch : batches) {
			System.out.println("Inserting " + batch);
			ksession.insert(batch);
		}
		
		Thread.sleep(1000);
	}

	private static KnowledgeBase readKnowledgeBase(String name) throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource(name), ResourceType.DRL);
		KnowledgeBuilderErrors errors = kbuilder.getErrors();
		if (errors.size() > 0) {
			for (KnowledgeBuilderError error: errors) {
				System.err.println(error);
			}
			throw new IllegalArgumentException("Could not parse knowledge.");
		}
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		return kbase;
	}
	
	public static class Latch {
		
		public final String name;
		public int aCount = 0;
		public int bCount = 0;
		public Set<Object> dataSet = Collections.newSetFromMap(new IdentityHashMap<Object,Boolean>());
		
		public Latch(String name) {
			this.name = name;
		}
		
		public String getName() {
			return name;
		}
		
		public Set<Object> getDataSet() {
			return dataSet;
		}
		
		public int incACount() {
			return ++aCount;
		}
		
		public int incBCount() {
			return ++bCount;
		}
		
		public String toString() {
			return "Latch " + name + ": (" + aCount + "As, " + bCount + "Bs)";
		}
	}

	public static class A {

		public A() {
		}
		
	}

	public static class B {

		public B() {
		}
		
	}

}