package com.sample;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

	public static final void main(String[] args) throws Exception {
		go();
	}

	protected static final long go() throws Exception {
		// load up the knowledge base
		KnowledgeBase kbase = readKnowledgeBase("in.drl");
		StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
		// go !
		long time = System.currentTimeMillis();
		for(int i = 0; i < 100; i++) {
			ksession.insert(new Foo(Double.toString(i / 10.0)));
		}
		ksession.setGlobal("hitCount", new Counter());
		ksession.fireAllRules();
		long duration = (System.currentTimeMillis() - time);

		System.out.println("in.drl Time: " + duration + "ms");
		System.out.println();

		return duration;
	}

	private static KnowledgeBase readKnowledgeBase(String name) throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource(name), ResourceType.DRL);
		KnowledgeBuilderErrors errors = kbuilder.getErrors();
		if(errors.size() > 0) {
			for(KnowledgeBuilderError error : errors) {
				System.err.println(error);
			}
			throw new IllegalArgumentException("Could not parse knowledge.");
		}
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		return kbase;
	}

	public static class Counter {
		public int count = 0;
	}

	public static class Foo {

		public String _thing;

		public Foo(String _thing) {
			super();
			this._thing = _thing;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((_thing == null) ? 0 : _thing.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if(this == obj)
				return true;
			if(obj == null)
				return false;
			if(getClass() != obj.getClass())
				return false;
			Foo other = (Foo) obj;
			if(_thing == null) {
				if(other._thing != null)
					return false;
			} else if(!_thing.equals(other._thing))
				return false;
			return true;
		}

		public String get_thing() {
			return _thing;
		}

		public void set_thing(String _thing) {
			this._thing = _thing;
		}

	}

}