from numpy import zeros, sum

def selectFlow(u, v, N, flow, d):
    
    uT = zeros([N+1,1],float)
    uB = zeros([N+1,1],float)
    vL = zeros([N+1,1],float)
    vR = zeros([N+1,1],float)
    
    if flow == 1:
        (u, v, uT, uB, vL, vR) = uniform(u, v, N, uT, uB, vL, vR)
    elif flow == 2:
        (u, v, uT, uB, vL, vR) = poiseuille(u, v, N, uT, uB, vL, vR, d)
    elif flow == 3:
        (u, v, uT, uB, vL, vR) = ld_cavity(u, v, N, uT, uB, vL, vR)
    elif flow == 4:
        (u, v, uT, uB, vL, vR) = rotating(u, v, N, uT, uB, vL, vR)
            
    return (u, v, uT, uB, vL, vR)

def uniform(u, v, N, uT, uB, vL, vR):

    # Normal velocities

    for k in range(0,N+1):
        u[k][0]  = 1.
        u[k][-1] = 1.
        v[0][k]  = 0.
        v[-1][k] = 0.

    # Tangential velocities

    for k in range(0,N+1):
        uT[k] = 1.
        uB[k] = 1.
        vL[k] = 0.
        vR[k] = 0.
    
    return (u, v, uT, uB, vL, vR)

def poiseuille(u, v, N, uT, uB, vL, vR, d):
    
    # Normal velocities    
    
    for i in range(0,N+1):
        if i == 0:
            y_var       = d[i]/2.
        else:
            y_var       = sum(d[0:i])+d[i]/2.
        u[i+1,0] = y_var*(1.-y_var);
        u[i+1,-1]= y_var*(1.-y_var);
        v[0,i+1] = 0.;
        v[-1,i+1]= 0.;

    # Tangential velocities

    for k in range(0,N+1):
        uT[k] = 0.
        uB[k] = 0.
        vL[k] = 0.
        vR[k] = 0.
    
    return (u, v, uT, uB, vL, vR)

def ld_cavity(u, v, N, uT, uB, vL, vR):
    
    # Normal velocities

    for k in range(0,N+1):
        u[k][0]  = 0.
        u[k][-1] = 0.
        v[0][k]  = 0.
        v[-1][k] = 0.

    # Tangential velocities

    for k in range(0,N+1):
        uT[k] = -1.
        uB[k] = 0.
        vL[k] = 0.
        vR[k] = 0.
        
    return (u, v, uT, uB, vL, vR)
    
def rotating(u, v, N, uT, uB, vL, vR):
    
    # Normal velocities

    for k in range(0,N+1):
        u[k][0]  = 0.
        u[k][-1] = 0.
        v[0][k]  = 0.
        v[-1][k] = 0.

    # Tangential velocities

    for k in range(0,N+1):
        uT[k] = -1.
        uB[k] = 1.
        vL[k] = -1.
        vR[k] = 1.
        
    return (u, v, uT, uB, vL, vR)