def centralCon(u,v,N,dx,dy):

    """ Convection terms in the x-direction """
    
    u2   = ( .5 * ( u[1:-1,1:] + u[1:-1,:-1] ) )**2
    u2_p = u2[:,1:]
    u2_n = u2[:,:-1]

    uv1  = ( ( dy[:-1,1:-2] * u[1:,1:-1] + dy[1:,1:-2]  * u[:-1,1:-1] ) / ( dy[:-1,1:-2] + dy[1:,1:-2]  ) )
    uv2  = ( ( dx[:-1,1:-2] * v[:,2:-1]  + dx[:-1,2:-1] * v[:,1:-2]   ) / ( dx[:-1,1:-2] + dx[:-1,2:-1] ) )
    uv   = uv1 * uv2
    uv_p = uv[:-1,:]
    uv_n = uv[1:,:]

    """ Convection terms in the y-direction """

    v2   = ( .5 * ( v[1:,1:-1] + v[:-1,1:-1] ) )**2
    v2_p = v2[1:,:]
    v2_n = v2[:-1,:]

    vu1  = ( ( dx[1:-2,:-1] * v[1:-1,1:] + dx[1:-2,1:]  * v[1:-1,:-1] ) / ( dx[1:-2,:-1] + dx[1:-2,1:]  ) )
    vu2  = ( ( dy[1:-2,:-1] * u[2:-1,:]  + dy[2:-1,:-1] * u[1:-2,:]   ) / ( dy[1:-2,:-1] + dy[2:-1,:-1] ) )
    vu   = vu1 * vu2
    vu_p = vu[:,:-1]
    vu_n = vu[:,1:]

    return u2_p, u2_n, uv_p, uv_n, v2_p, v2_n, vu_p, vu_n

def centralDif(u,v,N,dx,dy):

    """ Diffusion terms in the x-direction """
    
    dudx   = u[1:-1,1:] - u[1:-1,:-1]
    dudx_p = dudx[:,1:]  / dx[1:-1,2:-1]
    dudx_n = dudx[:,:-1] / dx[1:-1,1:-2]
    
    dudy   = u[1:,1:-1] - u[:-1,1:-1]
    dudy_p = dudy[1:,:]  / ( .5 * ( dy[2:,2:-1]   + dy[1:-1,2:-1] ) )
    dudy_n = dudy[:-1,:] / ( .5 * ( dy[1:-1,1:-2] + dy[:-2,1:-2]  ) )  
    
    """ Diffusion terms in the y-direction """
    
    dvdy   = v[1:,1:-1] - v[:-1,1:-1]
    dvdy_p = dvdy[1:,:]  / dy[2:-1,1:-1]
    dvdy_n = dvdy[:-1,:] / dy[1:-2,1:-1]

    dvdx   = v[1:-1,1:] - v[1:-1,:-1]
    dvdx_p = dvdx[:,1:]  / ( .5 * ( dx[2:-1,2:]   + dx[2:-1,1:-1] ) )
    dvdx_n = dvdx[:,:-1] / ( .5 * ( dx[1:-2,1:-1] + dx[1:-2,:-2]  ) )
    
    return dudx_p, dudx_n, dudy_p, dudy_n, dvdx_p, dvdx_n, dvdy_p, dvdy_n