from numpy import zeros
from centralDisc import centralCon, centralDif

def conDiff(u,v,N,dx,dy,Re,dt):
    
    [Cx, Cy] = convection(u,v,N,dx,dy)
    [Dx, Dy] = diffusion(u,v,N,dx,dy,Re)
    [Rx, Ry] = confusion(u,v,N,dx,dy,dt,Cx,Cy,Dx,Dy)
    R        = fluxEq(Rx,Ry,dx,dy)

    f = zeros([N*N], float)
    for i in range(0,N):
        for j in range(0,N):
            k = i * N + j
            f[k] = R[i,j]

    return Rx, Ry, f

def convection(u,v,N,dx,dy):
    
    [u2_p, u2_n, uv_p, uv_n, v2_p, v2_n, vu_p, vu_n] = centralCon(u,v,N,dx,dy)

    Cx =   u2_p * dy[1:-1,2:-1] \
         - u2_n * dy[1:-1,1:-2] \
         + uv_p * .5 * ( dx[1:-1,1:-2] + dx[1:-1,2:-1] ) \
         - uv_n * .5 * ( dx[:-2,1:-2]  + dx[:-2,2:-1]  )

    Cy =   v2_p * dx[2:-1,1:-1] \
         - v2_n * dx[1:-2,1:-1] \
         + vu_p * .5 * ( dy[1:-2,1:-1] + dy[2:-1,1:-1] ) \
         - vu_n * .5 * ( dy[1:-2,:-2]  + dy[2:-1,:-2]  )  

    return Cx, Cy

def diffusion(u,v,N,dx,dy,Re):
    
    [dudx_p, dudx_n, dudy_p, dudy_n, dvdx_p, dvdx_n, dvdy_p, dvdy_n] = centralDif(u,v,N,dx,dy)

    Dx = 1. / Re * ( - dudx_p * dy[1:-1,2:-1] \
                     + dudx_n * dy[1:-1,1:-2] \
                     - dudy_p * .5 * ( dx[1:-1,1:-2] + dx[1:-1,2:-1] ) \
                     + dudy_n * .5 * ( dx[:-2,1:-2]  + dx[:-2,2:-1]  ) )

    Dy = 1. / Re * ( - dvdy_p * dx[2:-1,1:-1] \
                     + dvdy_n * dx[1:-2,1:-1] \
                     - dvdx_p * .5 * ( dy[1:-2,1:-1] + dy[2:-1,1:-1] ) \
                     + dvdx_n * .5 * ( dy[1:-2,:-2]  + dy[2:-1,:-2]  ) )

    return Dx, Dy

def confusion(u,v,N,dx,dy,dt,Cx,Cy,Dx,Dy):
    
    Rx = zeros([N,N+1])
    Ry = zeros([N+1,N])

    Rx[:,0]    = u[1:-1,0]
    Rx[:,1:-1] = u[1:-1,1:-1] - 2. * dt / ( dy[1:-1,2:-1] * ( dx[1:-1,1:-2] + dx[1:-1,2:-1] ) ) * ( Cx + Dx )
    Rx[:,-1]   = u[1:-1,-1]

    Ry[0,:]    = v[0,1:-1]
    Ry[1:-1,:] = v[1:-1,1:-1] - 2. * dt / ( dx[2:-1,1:-1] * ( dy[1:-2,1:-1] + dy[2:-1,1:-1] ) ) * ( Cy + Dy )
    Ry[-1,:]   = v[-1,1:-1]

    return Rx, Ry

def fluxEq(Rx,Ry,dx,dy):

    R = ( Rx[:,1:] - Rx[:,:-1] ) * dy[1:-1,1:-1] + \
        ( Ry[1:,:] - Ry[:-1,:] ) * dx[1:-1,1:-1]

    return R
