from numpy import zeros, min, max, arange, dot, meshgrid
from matplotlib.pyplot import figure, draw, semilogy, contour, quiver, colorbar, pcolor

def plotConv(conv_u, conv_v, it):
    
    iter = arange(1,it)    
    
    figure()
    semilogy(iter, conv_u, 'b', iter, conv_v, 'g', basey = 10 )
    draw()
    
    return

def plotStream(nodes, u, v, N, dx, dy):
    
    stream = zeros([N+1,N+1], float)

    for i in range(0,N+1):
        for j in range(0,N+1):
            stream[j,i] = dot(u[1:j+1,i], dy[1:j+1,i]) - dot(v[j,1:i+1], dx[j,1:i+1])

    X, Y = meshgrid(nodes[0,0:N+1], nodes[0,0:N+1])
    
    c    = [0.1175, 0.115 , 0.11  , 0.1    , 9.e-2 , 7.e-2 , 5.e-2  , \
            3.e-2 , 1.e-2 , 1.e-4 , 1.e-5  , 1.e-10, 0.    , -1.e-6 , \
            -1.e-5, -5.e-5, -1.e-4, -2.5e-4, -5.e-4, -1.e-3, -1.5e-3  ]

    figure()
    contour(X, Y, stream, c)
    draw()
    
    return
    
def plotQuiver(nodes, u, v, N):
    
    x   = ( nodes[0,1:] + nodes[0,:-1] ) / 2.
    y   = ( nodes[1,1:] + nodes[1,:-1] ) / 2.

    u_c = ( u[1:-1,1:] + u[1:-1,:-1] ) / 2.
    v_c = ( v[1:,1:-1] + v[:-1,1:-1] ) / 2.
    
    V   = (u_c**2 + v_c**2)**.5
    u_c = u_c / V
    v_c = v_c / V
    
    figure()
    quiver(x, y, u_c, v_c)
    draw()
    
    return
    
def plotSurf(nodes, u, v, N, dx, dy):
    
    stream = zeros([N+1,N+1], float)

    for i in range(0,N+1):
        for j in range(0,N+1):
            stream[j,i] = dot(u[1:j+1,i], dy[1:j+1,i]) - dot(v[j,1:i+1], dx[j,1:i+1])

    X, Y = meshgrid(nodes[0,0:N+1], nodes[0,0:N+1])    
    
    
    figure()
    surface = pcolor(X, Y, stream, vmin = min(stream), vmax = max(stream))
    colorbar(surface)
    draw()
    
    return