from numpy import zeros

def dudt(u_n, v_n, Rx, Ry, p, dx, dy, dt):

    u_np = zeros(u_n.shape, float)
    v_np = zeros(v_n.shape, float)
    
    u_np[:,0]       = u_n[:,0]
    u_np[1:-1,1:-1] = Rx[:,1:-1] - dt * ( p[:,1:] - p[:,:-1] ) / ( .5 * ( dx[1:-1,1:-2] + dx[1:-1,2:-1] ) )
    u_np[:,-1]      = u_n[:,-1]
    
    v_np[0,:]       = v_n[0,:]
    v_np[1:-1,1:-1] = Ry[1:-1,:] - dt * ( p[1:,:] - p[:-1,:] ) / ( .5 * ( dy[1:-2,1:-1] + dy[2:-1,1:-1] ) )
    v_np[-1,:]      = v_n[-1,:]
    
    return u_np, v_np
