/*
 * Decompiled with CFR 0.152.
 */
package dk.swt.james.telnetadmin.gui;

import dk.swt.james.telnetadmin.gui.AccountModel;
import dk.swt.james.telnetadmin.net.Account;
import dk.swt.james.telnetadmin.net.InvalidLogonException;
import dk.swt.james.telnetadmin.net.NoSuchAccountException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class AccountAdminView
extends JFrame {
    private static final String version = "0.47";
    private static final String jamesVersion = "2.2.0a15";
    private static final String title = "Account Administration v. 0.47 for James v. 2.2.0a15";
    private JTextField serverName = new JTextField("localhost");
    private JTextField serverPort = new JTextField("4555");
    private JTextField adminID = new JTextField();
    private JPasswordField adminPW = new JPasswordField();
    private JLabel totalAccounts = new JLabel(" ");
    private JButton logonButton = new JButton("Logon");
    private JButton logoffButton = new JButton("Logoff");
    private JButton addButton = new JButton("Add account");
    private JButton aliasButton = new JButton("Set alias");
    private JButton forwardingButton = new JButton("Set forwarding");
    private JButton passwordButton = new JButton("Set password");
    private JButton removeButton = new JButton("Remove account");
    private JButton exitButton = new JButton("Exit");
    private JButton aboutButton = new JButton("About");
    private AccountModel accountModel;
    private JTable accountTable;
    private JScrollPane scrollPane;
    private int selectedRow = -1;

    static void about() {
        JOptionPane.showMessageDialog(null, " \nJames telnet account admin version 0.47\n \nNOTE - the code is solid but still at beta level - please report any buglets\nWorks with James 2.2.0a12 through 2.2.0a15\n(alias and forwarding handling not working if run with James 2.1.3 or previous versions)\nBuilt with Eclipse 2.1.1 using Sun JDK 1.4.2\n\nHard wired to talk to localhost only for security reasons\n\nJens A. Jensen, Sunway Software ApS, 10/03\njaj@swt.dk\n ", "ABOUT", 1);
    }

    public AccountAdminView() throws HeadlessException {
        super(title);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                AccountAdminView.this.doExit();
            }
        });
        this.logonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doLogon();
            }
        });
        this.logoffButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doLogoff();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doAdd();
            }
        });
        this.aliasButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doAlias();
            }
        });
        this.forwardingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doForwarding();
            }
        });
        this.passwordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doPassword();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doRemove();
            }
        });
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.this.doExit();
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AccountAdminView.about();
            }
        });
        this.createLayout();
        this.accountTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    AccountAdminView.this.selectedRow = -1;
                    AccountAdminView.this.getRootPane().setDefaultButton(null);
                } else {
                    AccountAdminView.this.selectedRow = lsm.getMinSelectionIndex();
                }
                AccountAdminView.this.checkState();
            }
        });
    }

    private void createLayout() {
        Box eastBox = Box.createVerticalBox();
        eastBox.add(new JLabel("Mailserver name"));
        eastBox.add(this.serverName);
        eastBox.add(new JLabel("Mailserver port"));
        eastBox.add(this.serverPort);
        eastBox.add(Box.createVerticalStrut(16));
        eastBox.add(new JLabel("adminID"));
        eastBox.add(this.adminID);
        eastBox.add(new JLabel("Password"));
        eastBox.add(this.adminPW);
        Dimension d = new Dimension(this.logonButton.getPreferredSize());
        if (this.logoffButton.getPreferredSize().width > d.width) {
            d = this.logoffButton.getPreferredSize();
        }
        if (this.addButton.getPreferredSize().width > d.width) {
            d = this.addButton.getPreferredSize();
        }
        if (this.aliasButton.getPreferredSize().width > d.width) {
            d = this.aliasButton.getPreferredSize();
        }
        if (this.forwardingButton.getPreferredSize().width > d.width) {
            d = this.forwardingButton.getPreferredSize();
        }
        if (this.passwordButton.getPreferredSize().width > d.width) {
            d = this.passwordButton.getPreferredSize();
        }
        if (this.removeButton.getPreferredSize().width > d.width) {
            d = this.removeButton.getPreferredSize();
        }
        if (this.exitButton.getPreferredSize().width > d.width) {
            d = this.exitButton.getPreferredSize();
        }
        if (this.aboutButton.getPreferredSize().width > d.width) {
            d = this.aboutButton.getPreferredSize();
        }
        this.logonButton.setMaximumSize(d);
        this.logoffButton.setMaximumSize(d);
        this.addButton.setMaximumSize(d);
        this.aliasButton.setMaximumSize(d);
        this.forwardingButton.setMaximumSize(d);
        this.passwordButton.setMaximumSize(d);
        this.removeButton.setMaximumSize(d);
        this.exitButton.setMaximumSize(d);
        this.aboutButton.setMaximumSize(d);
        this.logonButton.setMnemonic(76);
        this.logoffButton.setMnemonic(70);
        this.addButton.setMnemonic(65);
        this.aliasButton.setMnemonic(69);
        this.forwardingButton.setMnemonic(79);
        this.passwordButton.setMnemonic(80);
        this.removeButton.setMnemonic(82);
        this.exitButton.setMnemonic(88);
        this.aboutButton.setMnemonic(66);
        eastBox.add(Box.createVerticalStrut(this.logonButton.getPreferredSize().height));
        eastBox.add(this.totalAccounts);
        eastBox.add(Box.createVerticalStrut(this.logonButton.getPreferredSize().height));
        eastBox.add(this.logonButton);
        eastBox.add(this.logoffButton);
        eastBox.add(Box.createVerticalStrut(this.logonButton.getPreferredSize().height));
        eastBox.add(this.addButton);
        eastBox.add(this.aliasButton);
        eastBox.add(this.forwardingButton);
        eastBox.add(this.passwordButton);
        eastBox.add(this.removeButton);
        eastBox.add(Box.createVerticalStrut(this.logonButton.getPreferredSize().height));
        eastBox.add(this.exitButton);
        eastBox.add(this.aboutButton);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEtchedBorder());
        p.add(eastBox);
        this.getContentPane().add((Component)p, "West");
        this.accountModel = new AccountModel();
        this.accountTable = new JTable(this.accountModel);
        this.accountTable.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.accountTable);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = AccountAdminView.this.accountTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = AccountAdminView.this.accountTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1) {
                    // empty if block
                }
            }
        };
        JTableHeader th = this.accountTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.checkState();
    }

    private void doLogon() {
        String errMsg = null;
        boolean error = false;
        this.serverName.setText(this.serverName.getText().trim());
        this.serverPort.setText(this.serverPort.getText().trim());
        try {
            this.accountModel.logon(this.serverName.getText(), Integer.parseInt(this.serverPort.getText()), this.adminID.getText(), this.adminPW.getText());
        }
        catch (NumberFormatException e) {
            errMsg = "Invalid port '" + this.serverPort.getText() + "'.";
            this.serverPort.requestFocus();
            error = true;
        }
        catch (UnknownHostException e) {
            errMsg = "The mailserver '" + this.serverName.getText() + "' does not exist.";
            this.serverName.requestFocus();
            error = true;
        }
        catch (IOException e) {
            errMsg = "Cannot connect to mailserver '" + this.serverName.getText() + "'.";
            this.serverPort.requestFocus();
            error = true;
        }
        catch (InvalidLogonException e) {
            errMsg = "Invalid adminID or password.";
            this.adminID.requestFocus();
            error = true;
        }
        this.adminID.setText("");
        ((JTextComponent)this.adminPW).setText("");
        if (!error) {
            this.checkState();
        } else {
            JOptionPane.showMessageDialog(null, errMsg, "ERROR", 0);
        }
    }

    private void doLogoff() {
        this.accountModel.logoff();
        this.accountTable.revalidate();
        this.checkState();
    }

    private void doAdd() {
        String name = JOptionPane.showInputDialog(null, "Please type new account name", "Account NAME", 3);
        if ((name = name.trim()) == null || name.equals("")) {
            return;
        }
        String password = JOptionPane.showInputDialog(null, "Please type password for " + name, "Account PASSWORD", 3);
        if ((password = password.trim()) == null || password.equals("")) {
            JOptionPane.showMessageDialog(null, "Missing password\nAccount " + name + " NOT added", "INFORMATION", 1);
            return;
        }
        try {
            this.accountModel.addAccount(name, password);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
            return;
        }
        catch (InvalidLogonException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
            return;
        }
        catch (NoSuchAccountException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            return;
        }
        int row = this.accountModel.getAccountRow(name);
        this.accountTable.setRowSelectionInterval(row, row);
        this.checkState();
    }

    private void doAlias() {
        int selRow = this.selectedRow;
        Account selectedAccount = this.accountModel.getAccountAtRow(selRow);
        String name = selectedAccount.getName();
        String alias = selectedAccount.getAlias();
        String input = JOptionPane.showInputDialog("Type new alias for account " + name, (Object)alias);
        input = input.trim();
        boolean error = false;
        if (input == null) {
            error = true;
        } else if (alias.equals("") && input.equals("")) {
            error = true;
        } else if (alias.equals(input)) {
            error = true;
        } else if (name.equals(input)) {
            JOptionPane.showMessageDialog(null, "An account cannot alias itself", "ERROR", 0);
            error = true;
        }
        if (error) {
            this.accountTable.requestFocus();
            return;
        }
        try {
            if ("".equals(input)) {
                this.accountModel.removeAlias(name);
            } else {
                this.accountModel.setAlias(name, input);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (InvalidLogonException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (NoSuchAccountException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
        this.accountTable.setRowSelectionInterval(selRow, selRow);
        this.checkState();
    }

    private void doForwarding() {
        int selRow = this.selectedRow;
        Account selectedAccount = this.accountModel.getAccountAtRow(selRow);
        String name = selectedAccount.getName();
        String forward = selectedAccount.getForwarding();
        String input = JOptionPane.showInputDialog("Type new forwarding destination for account " + name + "\n(Must be a fully qualified mail address like xxx@yyy.zz)", (Object)forward);
        boolean error = false;
        if (input == null) {
            error = true;
        } else if (forward.equals("") && input.equals("")) {
            error = true;
        } else if (forward.equals(input)) {
            error = true;
        }
        if (error) {
            this.accountTable.requestFocus();
            return;
        }
        try {
            if ("".equals(input)) {
                this.accountModel.removeForwarding(name);
            } else {
                this.accountModel.setForwarding(name, input);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (InvalidLogonException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (NoSuchAccountException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
        this.accountTable.setRowSelectionInterval(selRow, selRow);
    }

    private void doPassword() {
        Account selectedAccount = this.accountModel.getAccountAtRow(this.selectedRow);
        String name = selectedAccount.getName();
        String input1 = JOptionPane.showInputDialog("Type new password for account " + name);
        String input2 = JOptionPane.showInputDialog("Retype new password for account " + name);
        boolean error = false;
        if (!input1.equals(input2)) {
            JOptionPane.showMessageDialog(null, "Passwords do not match", "ERROR", 0);
            error = true;
        }
        if (input1 == null) {
            error = true;
        } else if (input1.equals("")) {
            JOptionPane.showMessageDialog(null, "Empty passwords not allowed", "ERROR", 0);
            error = true;
        }
        if (error) {
            this.accountTable.requestFocus();
            return;
        }
        try {
            this.accountModel.setPassword(name, input1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (InvalidLogonException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
    }

    private void doRemove() {
        String selectedName = "";
        if (this.selectedRow > -1) {
            selectedName = this.accountModel.getAccountAtRow(this.selectedRow).getName();
        }
        String name = (String)JOptionPane.showInputDialog(null, "Please type account name to be removed", "Account removal", 3, null, null, selectedName);
        if ((name = name.trim()) == null || name.equals("")) {
            return;
        }
        if (JOptionPane.showConfirmDialog(null, "Removing an account cannot be undone\nMail may be lost\nIf " + name + " is an alias for other accounts, those aliases will be removed as well" + "\n\nDo you wish to remove account " + name + " anyway?", "Account removal CONFIRMATION", 0) == 1) {
            return;
        }
        try {
            this.accountModel.removeAccount(name);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (InvalidLogonException e) {
            JOptionPane.showMessageDialog(null, "Contact with server lost", "ERROR", 0);
            this.doLogoff();
        }
        catch (NoSuchAccountException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
        this.checkState();
    }

    private void doExit() {
        if (this.accountModel.isLoggedOn()) {
            if (JOptionPane.showConfirmDialog(null, "You are currently logged on\nExit anyway?\n(You will be logged off automatically)", "Do you really want to exit?", 0) == 1) {
                return;
            }
            this.doLogoff();
        }
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void checkState() {
        if (this.accountModel.isLoggedOn()) {
            this.serverPort.setEnabled(false);
            this.serverPort.setBackground(((Component)this).getBackground());
            this.totalAccounts.setText("" + this.accountTable.getRowCount() + " account" + (this.accountTable.getRowCount() == 1 ? "" : "s"));
            this.logonButton.setEnabled(false);
            this.logoffButton.setEnabled(true);
            this.addButton.setEnabled(true);
            if (this.selectedRow == -1) {
                this.aliasButton.setEnabled(false);
                this.forwardingButton.setEnabled(false);
                this.passwordButton.setEnabled(false);
            } else {
                this.aliasButton.setEnabled(true);
                this.forwardingButton.setEnabled(true);
                this.passwordButton.setEnabled(true);
            }
            this.removeButton.setEnabled(true);
            this.exitButton.setEnabled(false);
            this.adminID.setEnabled(false);
            this.adminID.setBackground(((Component)this).getBackground());
            this.adminPW.setEnabled(false);
            this.adminPW.setBackground(((Component)this).getBackground());
            this.getRootPane().setDefaultButton(null);
            if (this.selectedRow != -1) {
                int visibleRows = this.scrollPane.getViewport().getHeight() / this.accountTable.getRowHeight();
                int firstVisibleRow = this.scrollPane.getViewport().getViewPosition().y / this.accountTable.getRowHeight();
                int lastVisibleRow = firstVisibleRow + visibleRows - 1;
                if (this.selectedRow < firstVisibleRow) {
                    this.scrollPane.getViewport().setViewPosition(new Point(0, this.selectedRow * this.accountTable.getRowHeight()));
                } else if (this.selectedRow > lastVisibleRow) {
                    this.scrollPane.getViewport().setViewPosition(new Point(0, (firstVisibleRow + this.selectedRow - lastVisibleRow) * this.accountTable.getRowHeight()));
                }
            }
            this.accountTable.requestFocus();
        } else {
            this.serverName.setEnabled(false);
            this.serverName.setBackground(((Component)this).getBackground());
            this.serverPort.setEnabled(true);
            this.serverPort.setBackground(Color.white);
            this.adminID.setEnabled(true);
            this.adminID.setBackground(Color.white);
            this.adminPW.setEnabled(true);
            this.adminPW.setBackground(Color.white);
            this.totalAccounts.setText(" ");
            this.logonButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.logonButton);
            this.logoffButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.aliasButton.setEnabled(false);
            this.forwardingButton.setEnabled(false);
            this.passwordButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.exitButton.setEnabled(true);
            this.adminID.requestFocus();
        }
    }
}

