/*
 * Decompiled with CFR 0.152.
 */
package dk.swt.james.telnetadmin.gui;

import dk.swt.james.telnetadmin.net.Account;
import dk.swt.james.telnetadmin.net.InvalidLogonException;
import dk.swt.james.telnetadmin.net.NoSuchAccountException;
import dk.swt.james.telnetadmin.net.TelnetClient;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class AccountModel
extends AbstractTableModel {
    private TelnetClient server;
    private Account[] accounts;
    private String[] colNames = new String[]{"Account name", "Alias", "Forwarding destination"};

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public int getRowCount() {
        return this.accounts != null ? this.accounts.length : 0;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.accounts[row].getName();
            }
            case 1: {
                return this.accounts[row].getAlias();
            }
            case 2: {
                return this.accounts[row].getForwarding();
            }
        }
        return "";
    }

    public void logon(String serverName, int serverPort, String adminID, String adminPW) throws UnknownHostException, IOException, InvalidLogonException {
        this.server = new TelnetClient(serverName, serverPort);
        this.accounts = this.server.logon(adminID, adminPW);
        this.fireTableDataChanged();
    }

    public void logoff() {
        this.server.logoff();
        this.server = null;
        this.accounts = null;
    }

    public void addAccount(String name, String password) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.accounts = this.server.addAccount(name, password);
        this.fireTableDataChanged();
    }

    public void setAlias(String name, String alias) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.accounts = this.server.setAlias(name, alias);
        this.fireTableDataChanged();
    }

    public void removeAlias(String name) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.accounts = this.server.removeAlias(name);
        this.fireTableDataChanged();
    }

    public void setForwarding(String name, String forward) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.accounts = this.server.setForwarding(name, forward);
        this.fireTableDataChanged();
    }

    public void removeForwarding(String name) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.accounts = this.server.removeForwarding(name);
        this.fireTableDataChanged();
    }

    public void setPassword(String name, String password) throws IOException, InvalidLogonException {
        try {
            this.server.setPassword(name, password);
        }
        catch (NoSuchAccountException e) {
            this.accounts = this.server.refreshAccounts();
            this.fireTableDataChanged();
        }
    }

    public void removeAccount(String name) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.accounts = this.server.removeAccount(name);
        this.fireTableDataChanged();
    }

    public boolean isLoggedOn() {
        return this.accounts != null;
    }

    public int getAccountRow(String name) {
        return Arrays.binarySearch(this.accounts, new Account(name));
    }

    public Account getAccountAtRow(int row) {
        if (row < this.accounts.length) {
            return this.accounts[row];
        }
        return null;
    }
}

