/*
 * Decompiled with CFR 0.152.
 */
package dk.swt.james.telnetadmin.net;

import dk.swt.james.telnetadmin.net.Account;
import dk.swt.james.telnetadmin.net.InvalidLogonException;
import dk.swt.james.telnetadmin.net.NoSuchAccountException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;

public class TelnetClient {
    private static final String LISTUSERS_CMD = "listusers";
    private static final String ADDUSER_CMD = "adduser ";
    private static final String DELUSER_CMD = "deluser ";
    private static final String SETPASSWORD_CMD = "setpassword ";
    private static final String SETALIAS_CMD = "setalias ";
    private static final String UNSETALIAS_CMD = "unsetalias ";
    private static final String SHOWALIAS_CMD = "showalias ";
    private static final String SETFORWARDING_CMD = "setforwarding ";
    private static final String UNSETFORWARDING_CMD = "unsetforwarding ";
    private static final String SHOWFORWARDING_CMD = "showforwarding ";
    private String host;
    private int port;
    private String adminID;
    private String password;
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;
    private int numAccounts;
    private Account[] accounts;

    public TelnetClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.password = "";
        this.adminID = "";
    }

    public Account[] logon(String uid, String pw) throws IOException, UnknownHostException, InvalidLogonException {
        if (!this.adminID.equals("")) {
            throw new InvalidLogonException("Already logged on.");
        }
        this.adminID = uid;
        this.password = pw;
        this.connect();
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    public void logoff() {
        this.password = "";
        this.adminID = "";
    }

    public int countAccounts() throws InvalidLogonException {
        this.checkLoggedOn();
        return this.numAccounts;
    }

    public Account[] refreshAccounts() throws InvalidLogonException, IOException {
        this.checkLoggedOn();
        this.connect();
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    public void setPassword(String name, String password) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(SETPASSWORD_CMD + name.trim().toLowerCase() + " " + password.trim());
        String reply = this.in.readLine();
        if (reply.startsWith("No such")) {
            throw new NoSuchAccountException("Account " + name + " does not exist");
        }
        this.disconnect();
    }

    public Account[] addAccount(String name, String password) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(ADDUSER_CMD + name.trim().toLowerCase() + " " + password.trim());
        String reply = this.in.readLine();
        if (reply.endsWith("exists")) {
            try {
                throw new NoSuchAccountException("Account " + name + " already exists");
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.in.readLine();
                throw throwable;
            }
        }
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    public Account[] removeAccount(String name) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(DELUSER_CMD + name.trim().toLowerCase());
        String reply = this.in.readLine();
        if (reply.endsWith("exist")) {
            throw new NoSuchAccountException("Account " + name + " does not exist");
        }
        this.refresh();
        this.disconnect();
        int i = 0;
        while (i < this.accounts.length) {
            if (this.accounts[i].getAlias().equals(name)) {
                this.removeAlias(this.accounts[i].getName());
            }
            ++i;
        }
        return this.accounts;
    }

    public Account[] setAlias(String name, String alias) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(SETALIAS_CMD + name.trim().toLowerCase() + " " + alias.trim().toLowerCase());
        String reply = this.in.readLine();
        if (reply.startsWith("No such")) {
            throw new NoSuchAccountException("Account " + name + " does not exist");
        }
        if (reply.startsWith("Alias unknown")) {
            throw new NoSuchAccountException("Account " + alias + " does not exist");
        }
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    public Account[] removeAlias(String name) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(UNSETALIAS_CMD + name.trim().toLowerCase());
        String reply = this.in.readLine();
        if (reply.startsWith("No such")) {
            throw new NoSuchAccountException("Account " + name + " does not exist");
        }
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    public Account[] setForwarding(String name, String fwd) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(SETFORWARDING_CMD + name.trim().toLowerCase() + " " + fwd.trim().toLowerCase());
        String reply = this.in.readLine();
        if (reply.startsWith("No such")) {
            throw new NoSuchAccountException("Account " + name + " does not exist");
        }
        if (reply.startsWith("Parse exception")) {
            try {
                throw new NoSuchAccountException("Malformed mail address: " + fwd);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.in.readLine();
                throw throwable;
            }
        }
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    public Account[] removeForwarding(String name) throws IOException, InvalidLogonException, NoSuchAccountException {
        this.checkLoggedOn();
        this.connect();
        this.sendLine(UNSETFORWARDING_CMD + name.trim().toLowerCase());
        String reply = this.in.readLine();
        if (reply.startsWith("No such")) {
            throw new NoSuchAccountException("Account " + name + " does not exist");
        }
        this.refresh();
        this.disconnect();
        return this.accounts;
    }

    private void checkLoggedOn() throws InvalidLogonException {
        if (this.adminID.equals("")) {
            throw new InvalidLogonException("Please check your logon/logoff sequence.");
        }
    }

    private void refresh() throws IOException, InvalidLogonException {
        this.sendLine(LISTUSERS_CMD);
        String reply = this.in.readLine();
        this.numAccounts = Integer.parseInt(reply.substring(reply.lastIndexOf(" ") + 1));
        this.accounts = new Account[this.numAccounts];
        int i = 0;
        while (i < this.numAccounts) {
            reply = this.in.readLine();
            this.accounts[i] = new Account(reply.substring(reply.lastIndexOf(" ") + 1));
            ++i;
        }
        i = 0;
        while (i < this.numAccounts) {
            this.sendLine(SHOWALIAS_CMD + this.accounts[i]);
            reply = this.in.readLine();
            if (reply.startsWith("Current")) {
                this.accounts[i].setAlias(reply.substring(reply.lastIndexOf(" ") + 1));
            }
            this.sendLine(SHOWFORWARDING_CMD + this.accounts[i]);
            reply = this.in.readLine();
            if (reply.startsWith("Current")) {
                this.accounts[i].setForwarding(reply.substring(reply.lastIndexOf(" ") + 1));
            }
            ++i;
        }
        Arrays.sort(this.accounts);
    }

    private void sendLine(String cmd) {
        this.out.println(cmd);
        this.out.flush();
    }

    private void connect() throws IOException, InvalidLogonException {
        if (this.socket == null) {
            this.socket = new Socket(this.host, this.port);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream());
            this.in.readLine();
            this.in.readLine();
            this.in.readLine();
            this.sendLine(this.adminID);
            this.in.readLine();
            this.sendLine(this.password);
            if (("Login failed for " + this.adminID).equals(this.in.readLine())) {
                this.in.readLine();
                throw new InvalidLogonException("Invalid userID and/or password");
            }
        }
    }

    private void disconnect() throws IOException {
        try {
            this.in.close();
            this.out.println("quit");
            this.out.flush();
            this.out.close();
            this.socket.close();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.in = null;
            this.out = null;
            this.socket = null;
            throw throwable;
        }
        Object var1_3 = null;
        this.in = null;
        this.out = null;
        this.socket = null;
    }
}

