/*
 * Decompiled with CFR 0.152.
 */
package dk.swt.james.telnetadmin.net;

import dk.swt.james.telnetadmin.net.Account;
import dk.swt.james.telnetadmin.net.InvalidLogonException;
import dk.swt.james.telnetadmin.net.NoSuchAccountException;
import dk.swt.james.telnetadmin.net.TelnetClient;
import java.io.IOException;
import java.net.UnknownHostException;

public class TelnetClientTest {
    public static void main(String[] args) {
        TelnetClient tc = new TelnetClient("localhost", 4555);
        try {
            tc.logon("root", "root");
            System.out.println("Number of users: " + tc.countAccounts());
            Account[] users = tc.refreshAccounts();
            System.out.println("Usernames:");
            int i = 0;
            while (i < users.length) {
                System.out.println("\t" + users[i] + "\t\t" + users[i].getAlias() + "\t" + users[i].getForwarding());
                ++i;
            }
            tc.removeAccount("ppp");
            System.out.println("Account ppp removed.");
            tc.addAccount("ppp", "pp");
            System.out.println("Account ppp added.");
            tc.setPassword("ppp", "ppp");
            System.out.println("Password reset for ppp.");
            tc.setAlias("ppp", "000");
            System.out.println("Alias for ppp set to 000.");
            tc.removeAlias("ppp");
            System.out.println("Alias for ppp removed.");
            tc.setForwarding("ppp", "jaj@swt.dk");
            System.out.println("Forwarding for ppp set to jaj@swt.dk.");
            tc.removeForwarding("ppp");
            System.out.println("Forwarding for ppp removed.");
        }
        catch (UnknownHostException x) {
            System.err.println("Couldn't find host:\n\t" + x);
            System.exit(10);
        }
        catch (IOException x) {
            System.err.println("Error doing i/o:\n\t" + x);
            System.exit(20);
        }
        catch (InvalidLogonException x) {
            System.err.println("Couldn't logon:\n\t" + x);
            System.exit(30);
        }
        catch (NoSuchAccountException x) {
            System.err.println("Account does not exist:\n\t" + x);
            System.exit(30);
        }
        tc.logoff();
        System.exit(0);
    }
}

