package org.apache.james.smtpserver;

import org.apache.mailet.MailAddress;

import javax.mail.internet.ParseException;
import java.util.HashMap;
import java.util.ArrayList;
import java.net.InetAddress;

/** Holds state of SMTP protocol.
 *
 * @author Alexander Zhukov <zhukov@ukrpost.net>
 */
public class SMTPState {
    private HashMap stateMap = null;
    // Keys used to store/lookup data in the internal state hash map
    public final static String CURRENT_HELO_MODE = "CURRENT_HELO_MODE"; // HELO or EHLO
    public final static String SENDER = "SENDER_ADDRESS";     // Sender's email address
    public final static String MESG_FAILED = "MESG_FAILED";   // Message failed flag
    public final static String MESG_SIZE = "MESG_SIZE";       // The size of the message
    public final static String RCPT_LIST = "RCPT_LIST";   // The message recipients
    public final static String REMOTE_ADDR = "REMOTE_ADDR";

    public SMTPState(HashMap state) {
        this.stateMap = state;
    }

    public SMTPState() {
        stateMap = new HashMap();
    }

    public ArrayList getRecipientList() {
        return (ArrayList)stateMap.get(RCPT_LIST);
    }

    public boolean isMessageFailed() {
        return stateMap.containsKey(MESG_FAILED) && ((Boolean) stateMap.get(MESG_FAILED)).booleanValue();
    }

    public void setMessageFailed(boolean failed) {
        stateMap.put(MESG_FAILED, new Boolean(failed));
    }

    public void clear() {
        if ( getRecipientList() != null )
            getRecipientList().clear();
        stateMap.clear();
    }

    public void setHeloMode(String helomode) {
        stateMap.put(CURRENT_HELO_MODE, helomode);
    }

    public MailAddress getSender() {
        return (MailAddress)stateMap.get(SENDER);
    }

    public void setSender(MailAddress sender) {
        stateMap.put(SENDER, sender);
    }

    public void setSender(String sender) {
        try {
            setSender(new MailAddress(sender));
        } catch (ParseException e) {
        }
    }

    public void setMessageSize(Integer i) {
        stateMap.put(MESG_SIZE, i);
    }

    public void setRecipientList(ArrayList rcpts) {
        stateMap.put(RCPT_LIST, rcpts);
    }

    public void setRemoteHost(InetAddress inetAddress) {
        stateMap.put(REMOTE_ADDR, inetAddress);
    }

    public InetAddress getRemoteHost() {
        return (InetAddress) stateMap.get(REMOTE_ADDR);
    }
    public String toString() {
        return stateMap.toString();
    }
}
