#!/usr/bin/python2

# A utility that expects JSON array at a particular URL and lets you
# recursively extract commits data for a pull request from it.
# 
# The SHA-1 list is then sorted and returned to the caller.

import json
import sys
import urllib2
import os

class Commit:
  def __init__(self, sha, parentSha):
    self.sha = sha
    self.parentSha = parentSha

commits = []
orderedCommits = []

url = sys.argv[1]
userName = os.environ['SYS_GITHUB_LOGIN']
password = os.environ['SYS_GITHUB_PASSWORD']

passman = urllib2.HTTPPasswordMgrWithDefaultRealm()
passman.add_password(None, url, userName, password)
authhandler = urllib2.HTTPBasicAuthHandler(passman)
opener = urllib2.build_opener(authhandler)
urllib2.install_opener(opener)

data = json.loads(urllib2.urlopen(url).read())


for commit in data:
  try:
    sha = commit["sha"]
    parentSha = ""
    parents = commit["parents"]
    isFirst = False
    for parent in parents:
      if isFirst:
        print "Several parents"
        sys.exit(1)
      else:
        isFirst = True
        parentSha = parent["sha"]
    commits.append(Commit(sha, parentSha))
  except KeyError:
    print >> sys.stderr, "'" + arg + "' was not found"
    sys.exit(1)

while commits:
  commit = commits[0]
  commits.pop(0)
  hasParent = False
  for possibleParentCommit in commits:
    if possibleParentCommit.sha == commit.parentSha :
      hasPrent = True
      break
  if hasParent:
    commits.append(commit)
  else:
    orderedCommits.append(commit)

for commit in orderedCommits:
  print commit.sha
