#!/usr/bin/python2

# A utility that expects JSON data at a particular URL and lets you
# recursively extract keys from the JSON object as specified on the
# command line (each argument on the command line after the first will
# be used to recursively index into the JSON object). The name is a
# play off of 'curl'.

import json
import sys
import urllib2
import os

url = sys.argv[1]
userName = os.environ['SYS_GITHUB_LOGIN']
password = os.environ['SYS_GITHUB_PASSWORD']


passman = urllib2.HTTPPasswordMgrWithDefaultRealm()
passman.add_password(None, url, userName, password)
authhandler = urllib2.HTTPBasicAuthHandler(passman)
opener = urllib2.build_opener(authhandler)
urllib2.install_opener(opener)

data = json.loads(urllib2.urlopen(url).read())

for arg in sys.argv[4:]:
  try:
    temp = data[arg]
    data = temp
  except KeyError:
    print >> sys.stderr, "'" + arg + "' was not found"
    sys.exit(1)

print data
