#!/usr/bin/perl

package Logger;
use Sys::Hostname;
use Mail::Sendmail;
use Carp;
our $AUTOLOAD;

my(@months) = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
$hostname=hostname;
$logfile = "/var/log/test.log";
$application="$0";
$to='root';
$from='root';
$subject='Message From root@localhost';

sub new
 {
   my $that  = shift;
   my $class = ref($that) || $that;
   my (%parm)=@_;
   bless {
              logfile => $parm{'logfile'} || $logfile,
              application => $parm{'application'} || $application,
              to => $parm{'to'} || $to,
              from => $parm{'from'} || $from,
              subject => $parm{'subject'} || $subject
            } , $class ;
 }

##########Get/Set Params###############
sub logfile
{
 my($self,$logfile)=@_;
 if(defined($logfile))
   {
    $self->{logfile}=$logfile;
   }
 return $self->{logfile};
}

sub application
{
 my($self,$application)=@_;
 if(defined($application))
   {
    $self->{application}=$application;
   }
 return $self->{application};
}

sub to
{
 my($self,$to)=@_;
 if(defined($to))
   {
    $self->{to}=$to;
   }
 return $self->{to};
}

sub from
{
 my($self,$from)=@_;
 if(defined($from))
   {
    $self->{from}=$from;
   }
 return $self->{from};
}

sub subject
{
 my($self,$subject)=@_;
 if(defined($subject))
   {
    $self->{subject}=$subject;
   }
 return $self->{subject};
}
##########Log Function#############
sub log
{
 my $self=shift;
 my $msg=shift;
 my $name=$self->{logfile};
 my $application=$self->{application};
 open(LOG,">>$name");
 ($sec,$min,$hour,$day,$mon,$year)=localtime; $year+=1900; $realmon=$months[$mon];
 $now = sprintf("%s %d %.2d:%.2d:%.2d %s",$realmon,$day,$hour,$min,$sec,$hostname);
 print LOG "$now $application\[$$\]: $msg\n";
 close(LOG);
}

##########Icq Pager and Mail Sender##
sub icq_mail
{
 my $self=shift;
 my $msg=shift;
 my $to=shift;
 ($sec,$min,$hour,$day,$mon,$year)=localtime; $year+=1900; $realmon=$months[$mon];
 $now = sprintf("%s %d %.2d:%.2d:%.2d %s",$realmon,$day,$hour,$min,$sec,$hostname);

         %mail = ( To      => defined($to) ? $to: $self->{to}  ,
                   From    => $self->{from},
                   Message => $now . "\n" . $msg,
                   Subject => $self->{subject}
                  );

         sendmail(%mail);
}

1;

