/*
 * $Header: $
 * $Revision: 1.0 $
 * $Date:  $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.event;

import org.apache.slide.common.SlideToken;
import org.apache.slide.structure.ObjectNode;

import java.util.EventListener;
import java.util.EventObject;

/**
 * Structure event class
 *
 * @author <a href="mailto:dflorey@c1-fse.de">Daniel Florey</a>
 * @version $Revision: 1.0 $
 */
public class StructureEvent extends EventObject {
    public final static Retrieve RETRIEVE = new Retrieve();
    public final static Store STORE = new Store();
    public final static Create CREATE = new Create();
    public final static Remove REMOVE = new Remove();
    public final static CreateLink CREATE_LINK = new CreateLink();
    public final static AddBinding ADD_BINDING = new AddBinding();
    public final static RemoveBinding REMOVE_BINDING = new RemoveBinding();

    public final static String GROUP = "structure";
    public final static AbstractEventMethod[] methods = new AbstractEventMethod[] { RETRIEVE, STORE, CREATE, REMOVE, CREATE_LINK, ADD_BINDING, REMOVE_BINDING };

    private SlideToken token;
    private ObjectNode objectNode = null;
    private String uri = null;

    public StructureEvent(Object source, SlideToken token, String uri) {
        super(source);
        this.uri = uri;
        this.token = token;
    }

    public StructureEvent(Object source, SlideToken token, ObjectNode objectNode) {
        super(source);
        this.token = token;
        this.objectNode = objectNode;
    }

    public StructureEvent(Object source, SlideToken token, ObjectNode objectNode, String uri) {
        super(source);
        this.token = token;
        this.objectNode = objectNode;
        this.uri = uri;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(getClass().getName()).append("[uri=").append(uri);
        buffer.append(", objectNode=").append(objectNode);
        buffer.append("]");
        return buffer.toString();
    }

    public SlideToken getToken() {
        return token;
    }

    public ObjectNode getObjectNode() {
        return objectNode;
    }

    public String getUri() {
        return uri;
    }

    public final static class Create extends VetoableEventMethod {
        public Create() {
            super(GROUP, "create");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).create((StructureEvent)event);
        }
    }

    public final static class CreateLink extends VetoableEventMethod {
        public CreateLink() {
            super(GROUP, "create-link");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).createLink((StructureEvent)event);
        }
    }

    public final static class Remove extends VetoableEventMethod {
        public Remove() {
            super(GROUP, "remove");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).remove((StructureEvent)event);
        }
    }

    public final static class AddBinding extends VetoableEventMethod {
        public AddBinding() {
            super(GROUP, "add-binding");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).addBinding((StructureEvent)event);
        }
    }

    public final static class RemoveBinding extends VetoableEventMethod {
        public RemoveBinding() {
            super(GROUP, "remove-binding");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).removeBinding((StructureEvent)event);
        }
    }

    public final static class Store extends VetoableEventMethod {
        public Store() {
            super(GROUP, "store");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).store((StructureEvent)event);
        }
    }

    public final static class Retrieve extends VetoableEventMethod {
        public Retrieve() {
            super(GROUP, "retrieve");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof StructureListener ) ((StructureListener)listener).retrieve((StructureEvent)event);
        }
    }
}