/*
 * $Header: $
 * $Revision: 1.0 $
 * $Date:  $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.event;

import java.util.*;

/**
 * Event collection class
 *
 * @author <a href="mailto:dflorey@c1-fse.de">Daniel Florey</a>
 * @version $Revision: 1.0 $
 */
public class EventCollection extends EventObject {
    List collection = new ArrayList();

    public final static Collected COLLECTED = new Collected();
    public final static VetoableCollected VETOABLE_COLLECTED = new VetoableCollected();

    public final static String GROUP = "event-collection";
    public final static AbstractEventMethod[] methods = new AbstractEventMethod[] { COLLECTED, VETOABLE_COLLECTED };

    public EventCollection(Object source) {
        super(source);
    }

    public void addEvent(AbstractEventMethod method, EventObject event) {
        collection.add(new Event(method, event));
    }

    public List getCollection() {
        return collection;
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(getClass().getName()).append("[collected events=");
        for ( Iterator i = collection.iterator(); i.hasNext(); ) {
            buffer.append(NEWLINE);
            Event event = (Event)i.next();
            buffer.append("["+event.getClass().getName()+" [name="+event.getMethod().getId()+"]]");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static class Collected extends EventMethod {
        public Collected() {
            super(GROUP, "collected");
        }

        public void fireEvent(EventListener listener, EventObject event) {
            if (listener instanceof EventCollectionListener ) {
                ((EventCollectionListener)listener).collected((EventCollection)event);
            }
        }
    }

    public static class VetoableCollected extends VetoableEventMethod {
        public VetoableCollected() {
            super(GROUP, "vetoable-collected");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof EventCollectionListener ) {
                ((EventCollectionListener)listener).vetoableCollected((EventCollection)event);
            }
        }
    }

    class Event {
        private AbstractEventMethod method;
        private EventObject event;

        public Event(AbstractEventMethod method, EventObject event) {
            this.method = method;
            this.event = event;
        }

        public AbstractEventMethod getMethod() {
            return method;
        }

        public EventObject getEvent() {
            return event;
        }
    }
}