/*
 * $Header: $
 * $Revision: 1.0 $
 * $Date:  $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;

/**
 * Macro event class
 *
 * @author <a href="mailto:dflorey@c1-fse.de">Daniel Florey</a>
 * @version $Revision: 1.0 $
 */
public class MacroEvent extends EventObject {
    public final static Move MOVE = new Move();
    public final static Copy COPY = new Copy();
    public final static Delete DELETE = new Delete();

    public final static String GROUP = "macro";
    public final static AbstractEventMethod[] methods = new AbstractEventMethod[] { MOVE, COPY, DELETE };

    private String sourceURI, targetURI;

    public MacroEvent(Object source, String tagetURI) {
        this(source, null, tagetURI);
    }

    public MacroEvent(Object source, String sourceURI, String targetURI) {
        super(source);
        this.sourceURI = sourceURI;
        this.targetURI = targetURI;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(getClass().getName()).append("[source-uri=").append(sourceURI);
        buffer.append(", target-uri=").append(targetURI);
        buffer.append("]");
        return buffer.toString();
    }

    public final static class Copy extends VetoableEventMethod {
        public Copy() {
            super(GROUP, "copy");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if ( listener instanceof MacroListener ) ((MacroListener)listener).copy((MacroEvent)event);
        }
    }

    public final static class Move extends VetoableEventMethod {
        public Move() {
            super(GROUP, "move");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof MacroListener ) ((MacroListener)listener).move((MacroEvent)event);
        }
    }

    public final static class Delete extends VetoableEventMethod {
        public Delete() {
            super(GROUP, "delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof MacroListener ) ((MacroListener)listener).delete((MacroEvent)event);
        }
    }
}