/*
 * $Header: $
 * $Revision: 1.0 $
 * $Date:  $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.webdav.event;

import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.event.AbstractEventMethod;

import java.util.EventListener;
import java.util.EventObject;

/**
 * Webdav event class
 *
 * @author <a href="mailto:dflorey@c1-fse.de">Daniel Florey</a>
 * @version $Revision: 1.0 $
 */
public final class WebdavEvent extends EventObject {
    public static Get GET = new Get();
    public static Put PUT = new Put();
    public static PropFind PROPFIND = new PropFind();
    public static PropPatch PROPPATCH = new PropPatch();
    public static Bind BIND = new Bind();
    public static Rebind REBIND = new Rebind();
    public static Unbind UNBIND = new Unbind();
    public static Mkcol MKCOL = new Mkcol();
    public static Copy COPY = new Copy();
    public static Move MOVE = new Move();
    public static Delete DELETE = new Delete();
    public static Lock LOCK = new Lock();
    public static Unlock UNLOCK = new Unlock();
    public static Acl ACL = new Acl();
    public static Report REPORT = new Report();
    public static Search SEARCH = new Search();
    public static VersionControl VERSION_CONTROL = new VersionControl();
    public static Options OPTIONS = new Options();
    public static Checkin CHECKIN = new Checkin();
    public static Checkout CHECKOUT= new Checkout();
    public static Uncheckout UNCHECKOUT = new Uncheckout();
    public static Update UPDATE = new Update();
    public static Label LABEL = new Label();
    public static Mkworkspace MKWORKSPACE = new Mkworkspace();

    public final static String GROUP = "webdav";
    public final static AbstractEventMethod[] methods = new AbstractEventMethod[] { GET, PUT, PROPFIND, PROPPATCH, BIND,
                                                                                    UNBIND, REBIND, MKCOL, COPY, MOVE, DELETE, LOCK, UNLOCK, ACL,
                                                                                    REPORT, SEARCH, VERSION_CONTROL, OPTIONS, CHECKIN, CHECKOUT, UNCHECKOUT,
                                                                                    UPDATE, LABEL, MKWORKSPACE };

    public WebdavEvent(Object source) {
        super(source);
    }

    public AbstractEventMethod[] getMethods() {
        return methods;
    }

    public String getGroup() {
        return GROUP;
    }

    public final static class Get extends VetoableEventMethod {
        public Get() {
            super(GROUP, "get");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).get((WebdavEvent)event);
        }
    }

    public final static class Put extends VetoableEventMethod {
        public Put() {
            super(GROUP, "put");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).put((WebdavEvent)event);
        }
    }

    public final static class PropFind extends VetoableEventMethod {
        public PropFind() {
            super(GROUP, "propfind");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).propFind((WebdavEvent)event);
        }
    }

    public final static class PropPatch extends VetoableEventMethod {
        public PropPatch() {
            super(GROUP, "proppatch");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).propPatch((WebdavEvent)event);
        }
    }

    public final static class Bind extends VetoableEventMethod {
        public Bind() {
            super(GROUP, "bind");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).bind((WebdavEvent)event);
        }
   }

    public final static class Rebind extends VetoableEventMethod {
        public Rebind() {
            super(GROUP, "rebind");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).rebind((WebdavEvent)event);
        }
    }

    public final static class Unbind extends VetoableEventMethod {
        public Unbind() {
            super(GROUP, "unbind");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).unbind((WebdavEvent)event);
        }
    }

    public final static class Mkcol extends VetoableEventMethod {
        public Mkcol() {
            super(GROUP, "mkcol");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).mkcol((WebdavEvent)event);
        }
    }

    public final static class Copy extends VetoableEventMethod {
        public Copy() {
            super(GROUP, "copy");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).copy((WebdavEvent)event);
        }
    }

    public final static class Move extends VetoableEventMethod {
        public Move() {
            super(GROUP, "move");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).move((WebdavEvent)event);
        }
    }

    public final static class Delete extends VetoableEventMethod {
        public Delete() {
            super(GROUP, "delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).delete((WebdavEvent)event);
        }
    }

    public final static class Lock extends VetoableEventMethod {
        public Lock() {
            super(GROUP, "lock");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).lock((WebdavEvent)event);
        }
    }

    public final static class Unlock extends VetoableEventMethod {
        public Unlock() {
            super(GROUP, "unlock");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).unlock((WebdavEvent)event);
        }
    }

    public final static class Acl extends VetoableEventMethod {
        public Acl() {
            super(GROUP, "acl");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).acl((WebdavEvent)event);
        }
    }

    public final static class Report extends VetoableEventMethod {
        public Report() {
            super(GROUP, "report");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).report((WebdavEvent)event);
        }
    }

    public final static class Search extends VetoableEventMethod {
        public Search() {
            super(GROUP, "search");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).search((WebdavEvent)event);
        }
    }

    public final static class VersionControl extends VetoableEventMethod {
        public VersionControl() {
            super(GROUP, "version-control");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).versionControl((WebdavEvent)event);
        }
    }

    public final static class Options extends VetoableEventMethod {
        public Options() {
            super(GROUP, "options");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).options((WebdavEvent)event);
        }
    }

    public final static class Update extends VetoableEventMethod {
        public Update() {
            super(GROUP, "update");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).update((WebdavEvent)event);
        }
    }

    public final static class Checkin extends VetoableEventMethod {
        public Checkin() {
            super(GROUP, "checkin");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).checkin((WebdavEvent)event);
        }
    }

    public final static class Checkout extends VetoableEventMethod {
        public Checkout() {
            super(GROUP, "checkout");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).checkout((WebdavEvent)event);
        }
    }

    public final static class Uncheckout extends VetoableEventMethod {
        public Uncheckout() {
            super(GROUP, "uncheckout");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).uncheckout((WebdavEvent)event);
        }
    }

    public final static class Label extends VetoableEventMethod {
        public Label() {
            super(GROUP, "label");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).label((WebdavEvent)event);
        }
    }

    public final static class Mkworkspace extends VetoableEventMethod {
        public Mkworkspace() {
            super(GROUP, "mkworkspace");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException  {
            if ( listener instanceof WebdavListener ) ((WebdavListener)listener).label((WebdavEvent)event);
        }
    }
}