/*
 * Created on Jul 21, 2003
 *
 */
package fr.aliacom.lucene.store;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;

/**
 * Permet de r�cup�rer le store lucene � utiliser
 * 
 * @author tom
 *
 */
public class DirectoryFactory {

	private Map parameters;

	private Constructor constructor;

	private Log logger = LogFactory.getLog(getClass());

	private static DirectoryFactory singleton;

	static {
		try {
			singleton = new DirectoryFactory();
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}

	public static DirectoryFactory getInstance() {
		return singleton;
	}

	private DirectoryFactory() throws NamingException {
	}

	public Directory getDirectory() throws IOException {
		try {
			return (Directory) constructor.newInstance(
				new Object[] { parameters });
		} catch (Exception e) {
			e.printStackTrace();
			throw new IOException(e.getMessage());
		}
		//	return directoryInstance;
	}

	public void init(String className, Map parameters)
		throws
			ClassNotFoundException,
			SecurityException,
			NoSuchMethodException,
			IllegalArgumentException,
			InstantiationException,
			IllegalAccessException,
			InvocationTargetException {
		logger.info("Creating directory from class " + className);
		System.out.println("Creating directory from class " + className);
		Class directoryClass = Class.forName(className);

		try {
			constructor =
				directoryClass.getConstructor(new Class[] { Map.class });
		} catch (SecurityException e) {
		} catch (NoSuchMethodException e) {
		}
		this.parameters = parameters;
		/*
		if (constructor == null) {
			constructor = directoryClass.getConstructor(new Class[] {
			});
		
			directoryInstance =
				(Directory) constructor.newInstance(new Object[] {
			});
		
		} else {
		
			directoryInstance =
				(Directory) constructor.newInstance(
					new Object[] { parameters });
		}*/
	}
}