/*
 * Created on Apr 7, 2004
 *
 */
package fr.aliacom.lucene.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.aliacom.lucene.IConnectionFactory;

/**
 * @author tom
 *
 */
public class LuceneHelper {

	private static IConnectionFactory icf;
	private static Log logger = LogFactory.getLog(LuceneHelper.class);

	public static void init(IConnectionFactory confFactory) {
		if (confFactory == null) {
			throw new NullPointerException("ConnectionFactory cannot be null");
		}
		icf = confFactory;
	}

	static Connection getConnection() throws SQLException {
		checkTxStatus();
		return icf.getConnection();
	}

	private static void checkTxStatus() throws IllegalStateException {
		UserTransaction ut = icf.getUserTransaction();
		if (ut == null) {
			throw new IllegalStateException(
				"Your datasource must be "
					+ "managed by a transaction monitor.");
		}
		try {
			if (ut.getStatus() != Status.STATUS_ACTIVE) {
				throw new IllegalStateException("You must be in a transaction to use an SQL-linked store.");
			}
		} catch (SystemException e) {
			logger.warn("Could not get TX status", e);
		}
	}

	/**
	 * Ferme tout le 'JDBC crap' avec les tests qui vont bien.
	 * Seuls les paramètres non nuls seront fermés.
	 * 
	 * @param con
	 * @param st
	 * @param rs
	 * @throws SQLException
	 */
	public static void cleanup(Connection con, Statement st, ResultSet rs)
		throws SQLException {
		if (rs != null) {
			rs.close();
		}
		if (st != null) {
			st.close();
		}
		if (con != null) {
			con.close();
		}
	}

	/**
	 * Ferme tout le 'JDBC crap' avec les tests qui vont bien.
	 * Seuls les paramètres non nuls seront fermés.
	 * 
	 * @param con
	 * @param st
	 * @throws SQLException
	 */
	public static void cleanup(Connection con, Statement st)
		throws SQLException {
		if (con != null) {
			if (st != null) {
				st.close();
			}
			con.close();
		}
	}

	/**
	 * Cette methode est utilise avec oracle car rs.getBytes(column)
	 * produit des résultats douteux...
	 * 
	 * @param rs
	 * @param column
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public static byte[] readBlob(ResultSet rs, int column)
		throws IOException, SQLException {
		java.io.InputStream in = rs.getBinaryStream(column);
		if (in == null) {
			return null;
		}
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		int read = 0;
		while ((read = in.read(buf)) > 0) {
			out.write(buf, 0, read);
		}
		return out.toByteArray();
	}

}
