package fr.aliacom.lucene.store;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.NamingException;

import org.apache.lucene.store.OutputStream;

/**
 * @author nicolasr
 * cr le 13 juin 2003
 */
public class SQLOutputStream extends OutputStream {

	private String filename;
	//private Connection conn;
	private PreparedStatement pstSelect, pstUpdate, pstInsert;
	private ResultSet rs;
	private long length;
	private boolean closed;
	private long pos;

	/**
	 * @param name
	 */
	public SQLOutputStream(String name) {
		this.filename = name;
		//		conn = null;
		pstSelect = null;
		pstUpdate = null;
		pstInsert = null;
		rs = null;
		length = 0;
		pos = 0;
		closed = false;
	}

	/**
	 * @see org.apache.lucene.store.OutputStream#flushBuffer(byte[], int)
	 */
	protected void flushBuffer(byte[] b, int len) throws IOException {
		Connection conn = null;
		try {
			conn = getConnection();
			initSQL(conn);
		} catch (Exception e) {
			IOException ioe = new IOException(e.getMessage());
			ioe.initCause(e);
			throw ioe;
		}

		int nbBytesLeft = len;
		int nbBytesToWrite = nbBytesLeft;
		PreparedStatement pst = null;

		try {
			while (nbBytesLeft > 0) {

				final long segOrder = pos / SQLDirectory.SEGMENT_SIZE;
				final long segOffset =
					pos - (segOrder * SQLDirectory.SEGMENT_SIZE);

				// rcupration des valeurs existantes :
				pstSelect.setString(1, filename);
				pstSelect.setLong(
					2,
					(segOrder * SQLDirectory.SEGMENT_SIZE) + 1);
				//				System.out.println("slection de "+filename +" startByte : "+((segOrder*SQLDirectory.SEGMENT_SIZE)+1));
				rs = pstSelect.executeQuery();
				long startOrig = 0;
				long endOrig = 0;
				byte[] toWrite = null;
				if (rs.next()) {
					startOrig = rs.getLong(2);
					endOrig = rs.getLong(3);
					toWrite = LuceneHelper.readBlob(rs, 1);
				}

				nbBytesToWrite =
					Math.min(
						nbBytesToWrite,
						(int) (SQLDirectory.SEGMENT_SIZE * (segOrder + 1)
							- pos));

				int nbBytesWriten = 0;
				long startPos = startOrig;
				long endPos = endOrig;

				//if ((pos + 1) > endOrig) {
				if (startOrig == 0) {

					//					System.out.println("Inserting new record...");
					pst = pstInsert;

					startPos = (segOrder * SQLDirectory.SEGMENT_SIZE) + 1;
					endPos = startPos + nbBytesToWrite - 1;
				} else {
					//					System.out.println("Updating an existing blob...");
					pst = pstUpdate;
					pst.setLong(6, startOrig);

					endPos = Math.max(pos + nbBytesToWrite, endOrig);
				}

				//				System.out.println("pos = "+pos+" segOrder = "+segOrder+" segOffset = "+segOffset+" nbBytesLeft = "+nbBytesLeft+" nbBytesToWrite = "+nbBytesToWrite);
				//				System.out.println("startOrig = "+startOrig+" endOrig = "+endOrig+" startPos = "+startPos+" endPos = "+endPos);

				if (toWrite == null) {
					toWrite = new byte[nbBytesToWrite];

					//					System.out.println("flushBuffer() : copie de "+nbBytesToWrite+" octets depuis b["+nbBytesWriten+"] dans toWrite");
					System.arraycopy(
						b,
						nbBytesWriten,
						toWrite,
						0,
						nbBytesToWrite);

					pst.setBytes(1, toWrite);
				} else {

					// on modifie toWrite pour ajouter/modifier les nouveaux bytes,
					// et on setBytes
					//					System.out.println("flushBuffer() : copie de "+nbBytesToWrite+" octets depuis b["+nbBytesWriten+"] dans toWrite("+toWrite.length+")  partir de "+segOffset);
					System.arraycopy(
						b,
						nbBytesWriten,
						toWrite,
						(int) segOffset,
						nbBytesToWrite);

					pst.setBytes(1, toWrite);
				}
				nbBytesWriten = nbBytesToWrite;

				//  priori, start_byte ne peut pas changer pdt les updates
				// et le setLong(2, startPos) ne sert  RIEN
				pst.setLong(2, startPos);
				pst.setLong(3, endPos);
				pst.setLong(4, System.currentTimeMillis());
				pst.setString(5, filename);

				pst.executeUpdate();
				//				System.out.println("The prepared statement touched "+updateCount+" rows");

				pos += nbBytesWriten;
				nbBytesLeft -= nbBytesWriten;
				length += nbBytesWriten;

			}
		} catch (SQLException e) {
			e.printStackTrace();
			IOException ioe = new IOException(e.getMessage());
			ioe.initCause(e);
			throw ioe;
		} finally {
			closeSQL(conn);
		}
	}

	/**
	 * @see org.apache.lucene.store.OutputStream#length()
	 */
	public long length() throws IOException {
		return length;
	}
	/**
	 * @see org.apache.lucene.store.OutputStream#close()
	 */
	public void close() throws IOException {
		if (closed) {
			return;
		}
		super.close();
		closed = true;
		//		System.err.println("OutputStream("+filename+") closed");
	}

	private void closeSQL(Connection conn) throws IOException {
		boolean error = false;

		try {
			if (pstUpdate != null) {
				pstUpdate.close();
			}
		} catch (SQLException e) {
		}
		try {
			if (pstInsert != null) {
				pstInsert.close();
			}
		} catch (SQLException e) {
		}
		try {
			LuceneHelper.cleanup(conn, pstSelect, rs);
		} catch (SQLException e) {
			error = true;
		}

		if (error) {
			throw new IOException("Erreur pendant la fermeture de connection");
		}

	}

	private void initSQL(Connection conn) throws IOException {
		try {
			pstSelect =
				conn.prepareStatement(
					"select data, start_byte, end_byte "
						+ "from LUCENE where file_name= ? and start_byte = ?");
			pstUpdate =
				conn.prepareStatement(
					"update LUCENE set "
						+ " data = ?, "
						+ " start_byte = ?, "
						+ " end_byte = ?, "
						+ " last_modified = ? "
						+ " where "
						+ " file_name = ? and start_byte = ?");
			pstInsert =
				conn.prepareStatement(
					"insert into LUCENE "
						+ " (data, start_byte, end_byte, last_modified, file_name)"
						+ " values (?,?,?,?,?)");
		} catch (SQLException e) {
			IOException ioe = new IOException(e.getMessage());
			ioe.initCause(e);
			throw ioe;
		}
	}

	protected Connection getConnection()
		throws NamingException, SQLException, IOException {
		if (closed) {
			throw new IOException("OutputStream is closed");
		}
		return LuceneHelper.getConnection();
	}

	/**
	 * @see org.apache.lucene.store.OutputStream#seek(long)
	 */
	public void seek(long position) throws IOException {
		super.seek(position);
		//		System.err.println("OutputStream.seek() : moving to position " + position);
		pos = position;
	}

}
