/////////////////////////////////////////////////////////////////////
//
// Get.java
//
// AUTHOR     : Chris Malley, cmalley@pixelzoom.com
// REVISION   : $Revision: 1.2 $ $Date: 2001/10/22 20:39:30 $
// DESCRPTION : Client application that demonstrates SOAP Attachments. 
//              This client gets a file from the server.
//
/////////////////////////////////////////////////////////////////////

package putget;

// Java
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;

// Apache SOAP
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.util.mime.ByteArrayDataSource;


public class Get
{
  public static void main( String[] args ) throws Exception
  {
    //-------------------------------------------------------
    // Parse the command line.
    //-------------------------------------------------------
    
    if ( args.length != 3 )
    {
      System.err.println( "usage: Get servlet-URL from to" );
      return;
    }
    URL url = new URL( args[0] );
    String sourceFile = new String( args[1] );
    String destinationFile = new String( args[2] );

    //-------------------------------------------------------
    // Populate SOAP RPC call parameters.
    //-------------------------------------------------------

    Vector params = new Vector();
    params.addElement( new Parameter( "filename", 
                                      String.class, 
                                      new String(sourceFile), 
                                      null ) );

    //-------------------------------------------------------
    //  Build the SOAP RPC call.
    //-------------------------------------------------------
    
    Call call = new Call();
    call.setSOAPMappingRegistry( new SOAPMappingRegistry() );
    call.setTargetObjectURI( "urn:putget" );  // must match the DD.xml file
    call.setMethodName( new String("get") );
    call.setEncodingStyleURI( Constants.NS_URI_SOAP_ENC );
    call.setParams( params );

    //-------------------------------------------------------
    //  Invoke the SOAP RPC call.
    //-------------------------------------------------------
    
    Response response;
    try 
    {
      response = call.invoke( url, "" );
    }
    catch ( SOAPException e )
    {
      System.err.println( "SOAP Exception: " 
                        + e.getFaultCode() + ", " 
                        + e.getMessage() );
      e.printStackTrace();
      return;
    }

    //-------------------------------------------------------
    //  Handle SOAP faults.
    //-------------------------------------------------------
    
    if ( response.generatedFault() )
    {
      Fault fault = response.getFault();
      System.err.println( "SOAP Fault: " 
                        + fault.getFaultCode() + ", "
                        + fault.getFaultString() );
      return;
    }

    //-------------------------------------------------------
    // Process the SOAP response.
    //-------------------------------------------------------

    // Get the return value from the response.
    Parameter returnValue = response.getReturnValue();
    if ( returnValue == null )
    {
      System.out.println( "No return value." );
      return;
    }

    // Handle the binary attachment.
    DataHandler dh = (DataHandler)returnValue.getValue();
    DataSource ds = dh.getDataSource();

    // Write the bytes to the destination file.
    try 
    {
      ByteArrayDataSource bads = new ByteArrayDataSource( 
                                       ds.getInputStream(),
                                       dh.getContentType() );
      bads.writeTo( new FileOutputStream(destinationFile) );
    }
    catch ( IOException e ) 
    {
      System.out.println( e );
      e.printStackTrace( System.err );
      return;
    }
 
  } // main

} 

/////////////////////////////////////////////////////////////////////
// end of file
