/////////////////////////////////////////////////////////////////////
//
// Put.java
//
// AUTHOR     : Chris Malley, cmalley@pixelzoom.com
// REVISION   : $Revision: 1.2 $ $Date: 2001/10/22 20:39:30 $
// DESCRPTION : Client application that demonstrates SOAP Attachments. 
//              This client puts a file to the server.
//
/////////////////////////////////////////////////////////////////////

package putget;

// Java
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;

// Apache SOAP
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.util.mime.ByteArrayDataSource;


public class Put
{
  public static void main( String[] args ) throws Exception
  {
    //-------------------------------------------------------
    // Parse the command line.
    //-------------------------------------------------------
    
    if ( args.length != 3 )
    {
      System.err.println( "usage: Put servlet-URL from to" );
      return;
    }
    URL url = new URL( args[0] );
    String sourceFile = new String( args[1] );
    String destinationFile = new String( args[2] );

    //-------------------------------------------------------
    // Populate SOAP RPC call parameters.
    //-------------------------------------------------------
    
    Vector params = new Vector();
    params.addElement( new Parameter( "filename", 
                                       String.class, 
                                       destinationFile,
                                       null ) );
    // Create a binary attachment.
    DataSource ds;
    try 
    {
      ds = new ByteArrayDataSource( new File(sourceFile), null );
    }
    catch ( IOException e ) 
    {
      System.err.println( e );
      e.printStackTrace();
      return;
    }
    DataHandler dh = new DataHandler( ds );
    params.addElement( new Parameter( "filedata", 
                                      javax.activation.DataHandler.class,
                                      dh,
                                      null ) );

    //-------------------------------------------------------
    //  Build the SOAP RPC call.
    //-------------------------------------------------------
    
    Call call = new Call();
    call.setSOAPMappingRegistry( new SOAPMappingRegistry() );
    call.setTargetObjectURI( "urn:putget" );
    call.setMethodName( new String("put") );
    call.setEncodingStyleURI( Constants.NS_URI_SOAP_ENC );
    call.setParams( params );

    //-------------------------------------------------------
    //  Invoke the SOAP RPC call.
    //-------------------------------------------------------
    
    Response response;
    try 
    {
      response = call.invoke( url, "" );
    }
    catch ( SOAPException e )
    {
      System.err.println( "SOAPException: " 
                        + e.getFaultCode() + ", " 
                        + e.getMessage() );
      e.printStackTrace();
      return;
    }

    //-------------------------------------------------------
    //  Handle SOAP faults.
    //-------------------------------------------------------
    
    if ( response.generatedFault() )
    {
      Fault fault = response.getFault();
      System.err.println( "SOAP Fault: " 
                        + fault.getFaultCode() + ", "
                        + fault.getFaultString() );
      return;
    }

    //-------------------------------------------------------
    //  Process SOAP response.
    //-------------------------------------------------------
    
    Parameter returnValue = response.getReturnValue();
    if ( returnValue == null )
    {
      System.out.println( "No return value." );
    }
    else
    {
      System.out.println( "Return value: " + returnValue );
    }

  } // main

} 

/////////////////////////////////////////////////////////////////////
// end of file
