/////////////////////////////////////////////////////////////////////
//
// Server.java
//
// AUTHOR     : Chris Malley, cmalley@pixelzoom.com
// REVISION   : $Revision: 1.2 $ $Date: 2001/10/22 20:39:30 $
// DESCRPTION : Server application that demonstrates SOAP Attachments. 
//
/////////////////////////////////////////////////////////////////////

package putget;

// Java
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;

// Apache
import org.apache.soap.util.mime.ByteArrayDataSource;


public class Server
{

  // Default constructor
  public Server() { }

  // put - write the binary attachment to the destination file.
  public static String put( String destinationFile, DataHandler dh )
  throws IOException
  {
    DataSource ds = dh.getDataSource();
    ByteArrayDataSource bads = new ByteArrayDataSource( 
                                     ds.getInputStream(),
                                     dh.getContentType() );
    bads.writeTo( new FileOutputStream(destinationFile) );
    return destinationFile;
  }

  // get - create a binary attachment of the source file.
  public static DataHandler get( String sourceFile ) 
  throws IOException
  {
    DataSource ds;
    ds = new ByteArrayDataSource( new File(sourceFile), null );
    return new DataHandler( ds );
  }

}  // class Server

/////////////////////////////////////////////////////////////////////
// end of file
