/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import javax.servlet.ServletOutputStream;
import weblogic.server.Server;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.servlet.internal.ChunkOutputWrapper;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletInputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebService;
import weblogic.utils.io.Chunk;
import weblogic.utils.net.SocketResetException;

public final class ServletOutputStreamImpl
extends ServletOutputStream {
    private static final boolean DEBUG = false;
    private static final int CHUNK_SIZE = 4088;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean headersSent;
    private boolean inFinish = false;
    private ChunkOutputWrapper co;
    private Chunk hbuf;
    private int clen;
    private boolean nativeControlsPipe = false;
    private int hcount;
    private boolean enforceCL;
    private OutputStream out;
    private ServletResponseImpl impl;
    private boolean flushOK = true;
    private boolean autoFlush = true;
    private boolean doFinish = true;
    private int socketFD = -1;
    private HttpServer httper;
    private boolean writeEnabled = true;
    private boolean commitCalled = false;
    private static final byte[] FINAL_CHUNK = new byte[]{48, 48, 48, 48, 13, 10, 13, 10};

    public ServletOutputStreamImpl(OutputStream outputStream) {
        this(WebService.defaultHttpServer(), outputStream);
    }

    public ServletOutputStreamImpl(HttpServer httpServer, OutputStream outputStream) {
        this.setHttpServer(httpServer);
        this.out = outputStream;
        this.hbuf = Chunk.getChunk();
        ChunkOutput chunkOutput = ChunkOutput.create((int)8192, (boolean)true, (OutputStream)this.out, (ServletOutputStreamImpl)this);
        this.co = new ChunkOutputWrapper(chunkOutput);
        this.setBufferSize(8192);
        this.co.setChunking(false);
        this.clen = -1;
    }

    private final void checkCL(int n) throws IOException {
        if (!this.enforceCL) {
            return;
        }
        if (this.co.getTotal() + this.co.getCount() + n > this.clen) {
            throw new ProtocolException("Exceeded stated content-length of: '" + this.clen + "' bytes");
        }
    }

    public void clearBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.clearCurrentBuffer();
    }

    public void clearCurrentBuffer() {
        this.co.clearBuffer();
    }

    public void commit() throws IOException {
        block13: {
            if (this.commitCalled) {
                return;
            }
            if (!this.doFinish) {
                return;
            }
            if (this.nativeControlsPipe) {
                return;
            }
            int n = this.co.getTotal() + this.co.getCount();
            if (this.enforceCL && this.clen != n) {
                throw new ProtocolException("Didn't meet stated Content-Length, wrote: '" + n + "' bytes instead of stated: '" + this.clen + "' bytes.");
            }
            if (!this.headersSent && !this.enforceCL) {
                if ("HEAD".equals(this.impl.getMethod())) {
                    this.impl.setContentLength(this.clen);
                } else {
                    this.impl.setContentLength(n);
                }
            }
            try {
                this.inFinish = true;
                this.flush();
                if (!this.co.isChunking() || !this.flushOK) break block13;
                this.out.write(FINAL_CHUNK);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                String string = this.impl.getMethod();
                if ("POST".equalsIgnoreCase(string) || "PUT".equalsIgnoreCase(string)) {
                    ServletInputStreamImpl servletInputStreamImpl = this.impl.request.getServletInputStreamImpl();
                    int n2 = this.impl.request.getContentLength();
                    int n3 = servletInputStreamImpl.getBytesRead();
                    if (n3 < n2) {
                        servletInputStreamImpl.skip((long)(n2 - n3));
                    }
                }
                this.inFinish = false;
                this.co.setChunking(false);
                this.clen = -1;
                this.enforceCL = false;
                this.co.setWriteEnabled(false);
                this.commitCalled = true;
                throw throwable;
            }
        }
        Object var3_2 = null;
        String string = this.impl.getMethod();
        if ("POST".equalsIgnoreCase(string) || "PUT".equalsIgnoreCase(string)) {
            ServletInputStreamImpl servletInputStreamImpl = this.impl.request.getServletInputStreamImpl();
            int n = this.impl.request.getContentLength();
            int n4 = servletInputStreamImpl.getBytesRead();
            if (n4 < n) {
                servletInputStreamImpl.skip((long)(n - n4));
            }
        }
        this.inFinish = false;
        this.co.setChunking(false);
        this.clen = -1;
        this.enforceCL = false;
        this.co.setWriteEnabled(false);
        this.commitCalled = true;
    }

    public void finish() throws IOException {
        if (!this.commitCalled) {
            this.commit();
        }
        this.impl.resetOutputState();
        this.commitCalled = false;
        this.co.setWriteEnabled(true);
        if (this.flushOK && this.impl.getUseKeepAlive()) {
            this.co.reset();
            this.hbuf.next = null;
            this.hbuf.end = 0;
            this.headersSent = false;
        } else {
            this.co.release();
            this.freeChunks(this.hbuf);
            this.hbuf = null;
        }
    }

    public void flush() throws IOException {
        if (!this.headersSent) {
            this.sendHeaders();
        }
        if (this.nativeControlsPipe) {
            return;
        }
        if ("HEAD".equals(this.impl.getMethod())) {
            return;
        }
        try {
            this.co.flush();
        }
        catch (IOException iOException) {
            this.flushOK = false;
            if (this.inFinish && SocketResetException.isResetException((IOException)iOException)) {
                this.co.release();
                if (Server.getDebug().getDebugHttp()) {
                    HTTPLogger.logSocketResetException((Throwable)iOException);
                }
                return;
            }
            throw iOException;
        }
    }

    void flushBuffer() throws IOException {
        this.flush();
    }

    private void freeChunks(Chunk chunk) {
        while (chunk != null) {
            Chunk chunk2 = chunk.next;
            chunk.next = null;
            Chunk.releaseChunk((Chunk)chunk);
            chunk = chunk2;
        }
    }

    int getBufferSize() {
        return this.co.getBufferSize();
    }

    public int getCount() {
        return this.co.getCount();
    }

    private int getCurrentBufferSize() {
        return this.co.getBufferSize();
    }

    boolean getDoFinish() {
        return this.doFinish;
    }

    public Chunk getHeadersBuffer() {
        return this.hbuf;
    }

    public int getHeadersBufferLength() {
        return this.hcount;
    }

    public ChunkOutputWrapper getOutput() {
        return this.co;
    }

    OutputStream getRawOutputStream() {
        return this.out;
    }

    public int getSocketFD() {
        return this.socketFD;
    }

    int getTotal() {
        return this.co.getTotal();
    }

    boolean headersSent() {
        return this.headersSent;
    }

    boolean isCommitted() {
        return this.headersSent;
    }

    boolean isWriteEnabled() {
        return this.co.isWriteEnabled();
    }

    public void markHeadersSent(boolean bl) {
        this.headersSent = bl;
    }

    static void p(String string) {
        System.err.println("[ServletOS]: " + string);
    }

    public void print(String string) throws IOException {
        if (this.co.isWriteEnabled()) {
            if (string == null) {
                this.checkCL("null".length());
                this.co.print("null");
                return;
            }
            int n = string.length();
            this.checkCL(n);
            this.co.print(string);
        }
    }

    void reset() throws IllegalStateException {
        this.clearBuffer();
        this.enforceCL = false;
        this.clen = -1;
        this.co.setChunking(false);
    }

    void sendHeaders() throws IOException {
        if (this.headersSent) {
            return;
        }
        if (!this.inFinish && this.clen == -1 && "HTTP/1.1".equals(this.impl.request.getProtocol())) {
            this.co.setChunking(true);
            this.impl.addHeader("Transfer-Encoding", "Chunked");
        }
        if (!this.inFinish && this.clen == -1 && "HTTP/1.0".equals(this.impl.request.getProtocol())) {
            this.impl.setUseKeepAlive(false);
        }
        this.impl.writeHeaders();
        this.headersSent = true;
        this.freeChunks(this.hbuf.next);
        this.hbuf.next = null;
        this.hbuf.end = 0;
    }

    public void setAutoFlush(boolean bl) {
        this.autoFlush = bl;
    }

    void setBufferSize(int n) {
        this.co.setBufferSize(n);
    }

    public void setContentLength(int n) throws ProtocolException {
        if (this.enforceCL) {
            throw new ProtocolException("Content-Length already set");
        }
        if (!"HEAD".equals(this.impl.getMethod())) {
            this.enforceCL = true;
        }
        this.clen = n;
        this.co.setCL(this.clen);
        if (this.useKeepAliveHeader()) {
            this.impl.setHeader("Connection", "Keep-Alive");
        }
    }

    public void setDoFinish(boolean bl) {
        this.doFinish = bl;
    }

    public void setEnforceContentLength(boolean bl) {
        if ("HEAD".equals(this.impl.getMethod())) {
            this.enforceCL = false;
            return;
        }
        this.enforceCL = bl;
    }

    public void setHttpServer(HttpServer httpServer) {
        this.httper = httpServer;
    }

    public void setImpl(ServletResponseImpl servletResponseImpl) {
        this.impl = servletResponseImpl;
    }

    public void setNativeControlsPipe(boolean bl) {
        this.nativeControlsPipe = bl;
    }

    void setOutput(ChunkOutputWrapper chunkOutputWrapper) {
        this.co = chunkOutputWrapper;
    }

    public void setSocketFD(int n) {
        this.socketFD = n;
    }

    void setWriteEnabled(boolean bl) {
        this.co.setWriteEnabled(bl);
    }

    private boolean useKeepAliveHeader() {
        if ("HTTP/1.1".equals(this.impl.request.getProtocol())) {
            return false;
        }
        if (this.impl.hasKeepAliveHeader()) {
            return false;
        }
        return this.impl.getUseKeepAlive();
    }

    public void write(int n) throws IOException {
        if (this.nativeControlsPipe) {
            throw new IllegalStateException();
        }
        if (this.co.isWriteEnabled()) {
            this.checkCL(1);
            this.co.write(n);
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.nativeControlsPipe) {
            throw new IllegalStateException();
        }
        if (this.co.isWriteEnabled()) {
            this.checkCL(n2);
            this.co.write(byArray, n, n2);
        }
    }

    public void writeStream(InputStream inputStream) throws IOException {
        this.writeStream(inputStream, -1);
    }

    public void writeStream(InputStream inputStream, int n) throws IOException {
        if (this.clen <= this.getBufferSize()) {
            this.co.writeStream(inputStream, n, this.clen);
        } else {
            int n2 = 0;
            while (n2 < this.clen) {
                int n3 = this.clen - n2;
                if (n3 > this.getBufferSize()) {
                    n3 = this.getBufferSize();
                }
                this.co.writeStream(inputStream, n3, this.clen);
                n2 += n3;
            }
        }
    }

    public void writeStreamWithEncoding(InputStream inputStream) throws IOException {
        this.writeStream(inputStream, -1);
    }
}

