import sqlalchemy as rdb
from sqlalchemy import orm

class Soup(object):
    pass

class Collection(object):
    pass

class Relation(object):
    pass

class Record(object):
    pass

def setup(metadata):
    # soup table
    soup = rdb.Table(
        'soup',
        metadata,
        rdb.Column('id', rdb.Integer, primary_key=True, autoincrement=True),
        rdb.Column('uuid', rdb.String(length=32), unique=True, index=True),
        rdb.Column('spec', rdb.String, index=True),
        )

    # association table
    relations = rdb.Table(
        'relations',
        metadata,
        rdb.Column('id', rdb.Integer, primary_key=True, autoincrement=True),
        rdb.Column('left', rdb.String(length=32), rdb.ForeignKey("soup.uuid"), index=True),
        rdb.Column('right', rdb.String(length=32), rdb.ForeignKey("soup.uuid")),
        )
    
    # collection table
    collections = rdb.Table(
        'collections',
        metadata,
        rdb.Column('id', rdb.Integer, rdb.ForeignKey("soup.id"), primary_key=True),
         )

    # records table
    records = rdb.Table(
        'records',
        metadata,
        rdb.Column('id', rdb.Integer, rdb.ForeignKey("soup.id"), primary_key=True),
        rdb.Column('name', rdb.Unicode),
         )

    # both the collections and records tables are joined with the soup table
    collections = rdb.join(
        soup, collections, onclause=(collections.c.id==soup.c.id))

    records = rdb.join(
        soup, records, onclause=(records.c.id==soup.c.id))

    metadata.create_all()

    # orm mapping
    orm.mapper(Soup, soup)
    orm.mapper(Relation, relations)
    orm.mapper(Record, records)

    orm.mapper(Collection, collections, properties={
        'records': orm.relation(
        Soup,
        primaryjoin=soup.c.uuid==relations.c.left,
        secondary=relations,
        secondaryjoin=relations.c.right==soup.c.uuid,
        collection_class=list,
        enable_typechecks=False)
        })

