import unittest
import doctest

from zope.testing.doctestunit import DocFileSuite

import sqlalchemy as rdb
from sqlalchemy import orm

import tables

def setUp(test):
    engine = test._engine = rdb.create_engine('postgres://localhost/test')

    # set up session
    connection = engine.connect()
    global session
    Session = orm.sessionmaker(autoflush=True, transactional=True, echo_uow=True)
    session = Session(bind=connection)

    # set up metadata
    metadata = rdb.MetaData(engine)

    # set up tables
    tables.setup(metadata)
    
def tearDown(test):
    del test._engine
    
def test_suite():
    return unittest.TestSuite((
        DocFileSuite('README.txt',
                     setUp=setUp, tearDown=tearDown,
                     optionflags=doctest.NORMALIZE_WHITESPACE|doctest.ELLIPSIS,
                     ),
        ))

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
