import sqlalchemy as rdb
from sqlalchemy import orm

class Soup(object):
    pass

class Relation(object):
    pass

class Collection(Soup):
    pass

class Record(Soup):
    pass

class Rating(Soup):
    pass

class RatableRecord(Soup):
    pass

def setup(metadata):
    # soup table
    soup = rdb.Table(
        'soup',
        metadata,
        rdb.Column('id', rdb.Integer, primary_key=True, autoincrement=True),
        rdb.Column('uuid', rdb.String(length=32), unique=True, index=True),
        rdb.Column('spec', rdb.String, index=True),
        )

    # association table
    relations = rdb.Table(
        'relations',
        metadata,
        rdb.Column('id', rdb.Integer, primary_key=True, autoincrement=True),
        rdb.Column('left', rdb.String(length=32), rdb.ForeignKey("soup.uuid"), index=True),
        rdb.Column('right', rdb.String(length=32), rdb.ForeignKey("soup.uuid")),
        )
    
    # collection table
    collections = rdb.Table(
        '__builtin__:Icollections',
        metadata,
        rdb.Column('id', rdb.Integer, rdb.ForeignKey("soup.id"), primary_key=True),
         )

    # records table
    records = rdb.Table(
        'records',
        metadata,
        rdb.Column('id', rdb.Integer, rdb.ForeignKey("soup.id"), primary_key=True),
        rdb.Column('name', rdb.Unicode),
         )

    # ratings table
    ratings = rdb.Table(
        'ratings',
        metadata,
        rdb.Column('id', rdb.Integer, rdb.ForeignKey("soup.id"), primary_key=True),
        rdb.Column('rating', rdb.Integer),
         )

    ratable_record = records.join(ratings, onclause=(ratings.c.id==records.c.id))

    metadata.drop_all()
    metadata.create_all()

    # orm mapping
    orm.mapper(Soup, soup)
    orm.mapper(Relation, relations)
    orm.mapper(Record, records, inherits=Soup)
    orm.mapper(Rating, ratings, inherits=Soup)
        
    orm.mapper(RatableRecord, ratable_record,
               inherits=Soup, inherit_condition=(records.c.id==soup.c.id))

    orm.mapper(Collection, collections, inherits=Soup, properties={
        'records': orm.relation(
        Soup,
        primaryjoin=soup.c.uuid==relations.c.left,
        secondary=relations,
        secondaryjoin=relations.c.right==soup.c.uuid,
        collection_class=list,
        enable_typechecks=False)
        })

