#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sqlite3
from sqlalchemy import *
from sqlalchemy.orm import sessionmaker
from sqlalchemy.orm import scoped_session
from sqlalchemy.pool import NullPool
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import *
from sqlalchemy.types import *

Base = declarative_base()
METADATA = Base.metadata

class DataSet(Base):

    __tablename__ = 'data'
    id = Column(Integer, primary_key=True)
    data1 = Column(String(20))

    def __init__(self, data1):
        self.data1 = data1

class OrmManager:

    def  __init__(self, database, metadata, echo=False):

        engine = create_engine('sqlite:///' + database, echo=echo,
                                connect_args={'detect_types': sqlite3.PARSE_DECLTYPES|
                                              sqlite3.PARSE_COLNAMES},
                                native_datetime=True,
                                poolclass=NullPool,
                                convert_unicode=True
                              )

        metadata.create_all(engine)

        # this factory is thread safe: a session object is returned (always the same) to the
        # caller. If called from another thread, the returned session object will be different
        session_factory = sessionmaker(bind=engine, expire_on_commit=False)
        self.session_maker = scoped_session(session_factory)

    def get_session(self):

        return self.session_maker()



