#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time
import os
from orm import OrmManager, DataSet, METADATA
from sqlalchemy.orm.exc import NoResultFound
from writer import DB_IN_RAM, DB_NAME

REFRESH_DELAY_MS = 1000

# If ECHO is set to True, SQL statements are displayed _but_ do not seem to be issued
# to the underlying db on a session.query(...). A session.refresh(...) is needed to actually
# get fresh values from db
ECHO = False

def main():

    db_file = DB_NAME
    if DB_IN_RAM:
        db_file = os.path.join("/dev/shm", db_file)

    orm_mgr = OrmManager(db_file, METADATA, echo=ECHO)
    session = orm_mgr.get_session()

    while 1:
        data_set = session.query(DataSet).one()
        # uncomment this line to actually get a fresh value from db
        # session.refresh(data_set)
        print "[%s] - query: data1 = %s (session: %s)" % (time.time(), data_set.data1, session)
        time.sleep(REFRESH_DELAY_MS / 1000)

if __name__ == '__main__':
    main()
