#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time
import os
from orm import OrmManager, DataSet, METADATA
from sqlalchemy.orm.exc import NoResultFound

DB_NAME = "my_db.sqlite"
DB_IN_RAM = True
COMMIT_DELAY_MS = 5000

def main():

    db_file = DB_NAME
    if DB_IN_RAM:
        db_file = os.path.join("/dev/shm", db_file)

    if os.path.exists(db_file):
        os.remove(db_file)

    orm_mgr = OrmManager(db_file, METADATA)
    session = orm_mgr.get_session()

    while 1:
        try:
            data_set = session.query(DataSet).one()
        except NoResultFound:
            data_set = DataSet(data1="1")
            session.add(data_set)
            session.commit()
        if data_set.data1 == "1":
            data_set.data1 = "0"
        else:
            data_set.data1 = "1"
        print "[%s] - commit: data1 = %s (session: %s)" % (time.time(), data_set.data1, session)
        session.commit()
        time.sleep(COMMIT_DELAY_MS / 1000)

if __name__ == '__main__':
    main()
