
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import Integer, Unicode, Column, ForeignKey

Base = declarative_base()


class CommonPart(Base):
    __tablename__ = 'common_part'

    id = Column(Integer, primary_key=True)
    discriminator = Column(Unicode(20), nullable=False)

    __mapper_args__ = {
        'polymorphic_identity': u'common_part',
        'polymorphic_on': discriminator
    }


class RedPart(CommonPart):
    __tablename__ = 'red_part'
    __mapper_args__ = {'polymorphic_identity': u'red_part'}

    cp_id = Column(Integer, ForeignKey(CommonPart.id), primary_key=True)
    red_property = Column(Unicode(20), nullable=True)


class BluePart(CommonPart):
    __tablename__ = 'blue_part'
    __mapper_args__ = {'polymorphic_identity': u'blue_part'}

    cp_id = Column(Integer, ForeignKey(CommonPart.id), primary_key=True)
    blue_property = Column(Unicode(20), nullable=True)

