// Ben Clewett, April 2004
//
// Wrapper for SQLite to return a query as a table in memory.
//
// There is no warrenty, the code provided for illistation reasons only. Any user withing to make use of this does so at their own risk.

#ifndef SQLITE_WRAPPER
#define SQLITE_WRAPPER

#define HERE printf("%d@%s:HERE\n", __LINE__, __FILE__); fflush(stdout);

#include "sqlite3.h"

// Data structures:

// Meta data.  Column name and type
// Type :
// #define SQLITE_INTEGER  1
// #define SQLITE_FLOAT    2
// #define SQLITE_TEXT     3
// #define SQLITE_BLOB     4
// #define SQLITE_NULL     5
typedef struct {
	unsigned char type;
	char *name;
} sw_meta_data;

// Each cell of data in a linked-list.
// 'NULL' = NULL pointer
// All data as text.
typedef struct {
	const unsigned char *data;
	void *next;
} sw_cell_data;

// Result set.
// Access to linked list by linked list or by
// an array:
typedef struct {
	unsigned int col_count;
	unsigned int row_count;
	sw_cell_data **cell_array;
	sw_cell_data *cell_list;
	sw_meta_data *meta_data;
} sw_result;

// Main call:
// NULL = error
sw_result *sw_query(sqlite3 *handle, const char *query);

// Error interrogation:
int sw_get_errno();
const char *sw_get_errmsg();

// Free result
void sw_free_result(sw_result *result);

// Get cell data:
unsigned char sw_is_null(sw_result *result, unsigned int row, unsigned int col);
const unsigned char *sw_cell(sw_result *result, unsigned int row, unsigned int col);
int sw_cell_i(sw_result *result, unsigned int row, unsigned int col);
double sw_cell_d(sw_result *result, unsigned int row, unsigned int col);

// Table dimenstiona:
unsigned int sw_col_count(sw_result *);
unsigned int sw_row_count(sw_result *);

// Show table
void sw_show_table(sw_result *result, FILE *);
void sw_show_table_cvs(sw_result *result, FILE *);
void sw_show_table_xml(sw_result *result, FILE *, char *table_tag_name, char *row_tag_name);
void sw_show_table_html(sw_result *result, FILE *);



#endif
