// Ben Clewett, April 2004
//
// Wrapper for SQLite to return a query as a table in memory.

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "sqlite3.h"
#include "sqlite_wrapper.h"

void test_sql(char *sql);
void test_cvs(char *sql);
void test_xml(char *sql);
void test_html(char *sql);
sqlite3 *handle;
sw_result *result;

#define DATABASE "test.db"

int main (int argc, char **argv) {

	int ret;

	// New database
	remove(DATABASE);
	if ((ret = sqlite3_open(DATABASE, &handle)) != SQLITE_OK) {
		printf("Error opening: %d\n", ret);
		exit(1);
	}

	// create table
	test_sql("CREATE TABLE test ( a INTEGER, b VARCHAR(10))");

	// populate:
	test_sql("INSERT INTO test (a,b) VALUES (1, 'A')");
	test_sql("INSERT INTO test (a,b) VALUES (2, 'B')");
	test_sql("INSERT INTO test (a,b) VALUES (NULL, 'C')");
	test_sql("INSERT INTO test (a,b) VALUES (4, NULL)");
	test_sql("INSERT INTO test (a,b) VALUES (NULL, NULL)");

	// Test select:
	test_sql("SELECT * FROM test");

	// Test scalar:
	test_sql("SELECT COUNT(*) FROM test");

	// Test bigger select:
	test_sql("SELECT a.a, a.b, b.a, b.b as end_column FROM test as a, test as b");

	// Test massive select:
//	test_sql("SELECT * FROM test as a, test as b, test as c, test as d");

	// test cvs:
	test_cvs("SELECT * FROM test");

	// test xml:
	test_xml("SELECT * FROM test");

	// test html:
	test_html("SELECT * FROM test");

	// Drop table:
	test_sql("DROP TABLE test");

	// Deliberate error:
	test_sql("this will cause an error because no sql here");

	printf("-------------------------------------------------------------------------------\n");

	exit(0);
}


void test_sql(char *sql)
{
	printf("-------------------------------------------------------------------------------\n");

	printf("SQL:   '%s'\n", sql);

	result = sw_query(handle, sql);

	if (result == NULL) {
		printf("Error: '%d', '%s'\n", sw_get_errno(), sw_get_errmsg());
		return;
	}

	printf("Rows:  '%d'    Colunms: '%d'\n", sw_row_count(result), sw_col_count(result));

	if (sw_row_count(result) == 0) {
		return;
	}

	// Show table:
	sw_show_table(result, stdout);

	sw_free_result(result);

}

void test_cvs(char *sql)
{
	printf("-------------------------------------------------------------------------------\n");

	printf("SQL:    '%s'\n", sql);
	printf("Output: 'cvs'\n\n");

	result = sw_query(handle, sql);

	if (result == NULL) {
		printf("Error: '%d', '%s'\n", sw_get_errno(), sw_get_errmsg());
		return;
	}

	if (sw_row_count(result) == 0) {
		return;
	}

	// Show table:
	sw_show_table_cvs(result, stdout);

	sw_free_result(result);

}

void test_xml(char *sql)
{
	printf("-------------------------------------------------------------------------------\n");

	printf("SQL:    '%s'\n", sql);
	printf("Output: 'xml'\n\n");

	result = sw_query(handle, sql);

	if (result == NULL) {
		printf("Error: '%d', '%s'\n", sw_get_errno(), sw_get_errmsg());
		return;
	}

	if (sw_row_count(result) == 0) {
		return;
	}

	// Show table:
	sw_show_table_xml(result, stdout, "TABLE", "ROW");

	sw_free_result(result);

}

void test_html(char *sql)
{
	printf("-------------------------------------------------------------------------------\n");

	printf("SQL:    '%s'\n", sql);
	printf("Output: 'xml'\n\n");

	result = sw_query(handle, sql);

	if (result == NULL) {
		printf("Error: '%d', '%s'\n", sw_get_errno(), sw_get_errmsg());
		return;
	}

	if (sw_row_count(result) == 0) {
		return;
	}

	// Show table:
	sw_show_table_html(result, stdout);

	sw_free_result(result);

}


