# -*- coding: UTF-8 -*-

from SQLObject import *
from wmconf import *
__connection__ = SQLiteConnection(database, debug=False)

class gruppe(SQLObject):
    name = StringCol(alternateID=1)
    teams = MultipleJoin("team", orderBy=['-points', '-diff'])
    _defaultOrder = "name"
    
class team(SQLObject):
    name = StringCol(alternateID=1)
    gruppe = ForeignKey("gruppe")
    goals = IntCol(default=0)
    antigoals = IntCol(default=0)
    diff = IntCol(default=0)
    points = IntCol(default=0)
    matches = IntCol(default=0)

class game(SQLObject):
    team1 = ForeignKey("team")
    team2 = ForeignKey("team")
    results = MultipleJoin("result")
    
class result(SQLObject):
    goals1 = IntCol(notNone=False)
    goals2 = IntCol(notNone=False)
    game = ForeignKey("game")

class wmuser(SQLObject):
    name = StringCol(alternateID=1)
    pw   = StringCol()

worldcup = {
"A": [
"Deutschland",
"Ecuador",
"Polen",
"Costa Rica"
],

"B": [
"England",
"Trinidad und Tobago",
"Schweden",
"Paraguay",
],

"C": [
"Argentinien",
"Elfenbeink&uuml;ste",
"Serbien und Montenegro",
"Niederlande",
],

"D": [
"Mexiko",
"Iran",
"Angola",
"Portugal",
],

"E": [
"Italien",
"Ghana",
"USA",
"Tschechische Republik",
],

"F": [
"Brasilien",
"Kroatien",
"Australien",
"Japan",
],

"G": [
"Frankreich",
"Schweiz",
"S&uuml;dkorea",
"Togo",
],

"H": [
"Spanien",
"Ukraine",
"Tunesien",
"Saudi-Arabien",
]
}


def add_game_result(game, goals1, goals2):
    
    # first clear: 
    for old_r in game.results:
        del_game_result(old_r.id)

    r = result.new(game=game, goals1=goals1, goals2=goals2)
    t1 = r.game.team1
    t2 = r.game.team2
    print "%s:%s" % (t1.name, t2.name)
    print "%s:%s" % (r.goals1, r.goals2)
    
    if r.goals1 > r.goals2:
        t1.points += 3
    elif r.goals1 < r.goals2:
        t2.points += 3
    elif r.goals1 == r.goals2:
        t1.points += 1
        t2.points += 1
        
    t1.goals += r.goals1
    t1.antigoals += r.goals2
    t2.goals += r.goals2
    t2.antigoals += r.goals1
    
    t1.diff = t1.goals - t1.antigoals
    t2.diff = t2.goals - t2.antigoals
    
    t1.matches += 1
    t2.matches += 1
    return r

def del_game_result(rid):
    try:
        r = result(rid)
    except:
        return "Kein Result mit id %s vorhanden" % rid
    t1 = r.game.team1
    t2 = r.game.team2
    #print "%s:%s" % (t1.name, t2.name)
    #print "%s:%s" % (r.goals1, r.goals2)
    
    if r.goals1 > r.goals2:
        t1.points -= 3
    elif r.goals1 < r.goals2:
        t2.points -= 3
    elif r.goals1 == r.goals2:
        t1.points -= 1
        t2.points -= 1
        
    t1.goals -= r.goals1
    t1.antigoals -= r.goals2
    t2.goals -= r.goals2
    t2.antigoals -= r.goals1
    
    t1.diff = t1.goals - t1.antigoals
    t2.diff = t2.goals - t2.antigoals
    
    t1.matches -= 1
    t2.matches -= 1
    r.expire()
    r.destroySelf()
    return ""
    #print "destroyed R"

def setup_WM():
    global worldcup
    for g in worldcup.keys():
        gnew = gruppe.new(name=g)
        for t in worldcup[g]:
            tnew = team.new(name=t, gruppe=gnew)

def add_game(team1, team2):
    t1 = team.byName(team1)
    t2 = team.byName(team2)
    g = game.new(team1=t1, team2=t2)
    return g.id

    
if __name__=="__main__":
    import os
    if raw_input("delete old tables? [Yn] ") in "yY":
    #if 1:
#        if raw_input("should I create a backup first? [Yn]") in "yY":
#            backup = raw_input("backup to which file? [backup.sql]") or "backup.sql"
#            os.system("echo .dump | sqlite %s > %s " % (database, backup))
#            print "dumped database to %s" % backup
#        print "deleting and recreating tables...",
        for tab in (gruppe, team, game, result, wmuser):
            tab.dropTable(ifExists=True)
            tab.createTable()
        #print " done"

    setup_WM()

#    a = gruppe.new(name="A")
#    d = team.new(name="Deutschland", gruppe=a)
#    cr = team.new(name="Costa Rica", gruppe=a)
#    g = game.new(team1=d, team2=cr)
#    g1 = game.new(team1=d, team2=cr)
#    print a, d, cr, g
#
#    add_game_result(g, 4, 2)
#    rtmp = add_game_result(g, 3, 3)
#
#    for t in team.select("all"):
#        print t
#    
#    del_game_result(rtmp)
#    

    gamefile = open("wcgames.txt")
    for l in gamefile:
        t1, t2 = l.split(":")
        t1 = t1.strip()
        t2 = t2.strip()
        add_game(t1, t2)

#    gid = add_game("Polen", "Ecuador")
#    g = game(gid)
#    add_game_result(g, 0, 2)
    
    for g in gruppe.select("all"):
        print
        print "Gruppe ", g.name
        print "--------"
        for t in g.teams:
            print t.name, t.points
    
    print "---------"
    print "All games"
    print "---------"
    
    for g in game.select("all"):
        print "%s : %s" % (g.team1.name, g.team2.name)

#    g = game(gid)
#    add_game_result(g, 0, 2)
    print "__ setting up cms editor __"
    name = raw_input("username: ")
    pw = raw_input("password: ")
    u = wmuser.new(name=name, pw=pw)
    if u: print "done"
    
    
