from WebKit.Page import Page
from WebUtils.Funcs import htmlEncode as qu

from wmconf import *
from threading import *
from WM import *

class WMPage(Page):
    
    def awake(self, trans):
        self._lock = RLock()
        Page.awake(self, trans)
        self._conn = SQLiteConnection(database)
        self.error=""        
    
    def htBodyArgs(self):
        return ""

    def title(self):
        return ("WM spielplan")

    def writeStyleSheet(self):
        self.w(css)
    
    
    def writeBodyParts(self):
        self.writePre()
        self.writeFooter()
        self.w("""<div id="middle"><div class="column-in">""")
        self.writeContent()
        self.writePost()
    
    def writePre(self):
        self.w("""
<div id="header">
</div>

<div id="main1"><div id="main2">
    <div id="left"><div class="column-in">
    </div></div>
        """)
    
    def writePost(self):
        self.w("""
</div></div>
    <div class="cleaner">&nbsp;</div>
    </div></div>
    <div id="footer"><div class="column-in">
            <a href="logout">bye</a><b>.</b>
    </div></div>
        """) 
    
    def loginForm(self):
        self.w("""
        <form method="post" action="">
            <input type="hidden" name="_action_login">
            <b>usr:</b> <br>
            <input type="text" name="Email">
            <br><b>pw:</b> <br>
            <input type="password" name="Password"><br>
            <input type="submit" value="login">
        </form>
        """)

    def loggedIn(self):
        return self.session().value("WMloggedIn", None)
    
    def login(self):
        ses = self.session()
        ses.values().clear()
        req    = self.request()
        email  = req.value("Email", '').strip()
        pw = req.value("Password", '').strip()
        u = None
        try:
            u = wmuser.byName(email)
        except:
            u = None
        if u:
            if u.pw == pw:
                ses.setValue("WMloggedIn", u.name)
            else:
                ses.setValue("WMloggedIn", None)
        self.writeBody()

    def tabelle(self):
        self.w("<pre>")
        for g in gruppe.select("all"):
            self.w("")
            self.w("--------")
            self.w("Gruppe %s" % g.name)
            self.w("--------")
            for t in g.teams:
                fill = {"name": t.name, 
                        "points": t.points, 
                        "matches": t.matches, 
                        "goals": t.goals,
                        "antigoals": t.antigoals,
                        "goaldiff": t.diff
                        }
                        
                self.w("""%(name)s: 
  %(points)s Punkte
  %(goals)s:%(antigoals)s Tore
  %(goaldiff)s Tordifferenz
  %(matches)s Spiele""" % fill)
        self.w("</pre>")
    
    def html_tabelle(self):
        for g in gruppe.select("all"):
            self.w("""<br /><br /><span class="text_bold">Gruppe %s</span><br />""" % g.name)
            self.w("""
<table cellpadding="4" cellspacing="1" style="font-size:1em; font-family:verdana,arial,sans-serif;">
    <tr>
        <td width="140"></td></td>
        <td>Spiele</td>

        <td>Punkte</td>
        <td>Tore</td>
    </tr>
    """)
            row = 0
            for t in g.teams:
                c = """ bgcolor="#e2e3de" """
                if row % 2:
                    c = ""
                row += 1
                fill = {"name": t.name, 
                        "points": t.points, 
                        "matches": t.matches, 
                        "goals": t.goals,
                        "antigoals": t.antigoals,
                        "goaldiff": t.diff,
                        "color": c
                        }
                        
                self.w("""
    <tr>
        <td %(color)s>%(name)s</td>
        <td %(color)s>%(matches)s</td>
        <td %(color)s>%(points)s</td>
        <td %(color)s>%(goals)s:%(antigoals)s (%(goaldiff)s)</td>
    </tr>
""" % fill)
        
            self.w("""</table>""")
    
    def writeFooter(self):
        self.w("""<div id="Menu">""")
        self.w("""<ul>
    <li><a href="index">Eingabemaske</a></li>
    <li><a href="tabelle">Tabelle</a> (Quelltext)</li>
    <li><a href="preview">Tabelle</a> (Vorschau)</li>
</ul>""")
        self.html_tabelle()
        self.w("""</div>""")
        
    def loginForm(self):
        self.w("""
        <form method="post" action="">
            <input type="hidden" name="_action_login">
            <b>usr:</b> <br>
            <input type="text" name="Email">
            <br><b>pw:</b> <br>
            <input type="password" name="Password"><br>
            <input type="submit" value="login">
        </form>
        """)
    
    def w(self, text=""):
        self.writeln(text)
    
    def get_games(self):
        try:
            self._lock.acquire()
            games = game.select("all")
            self._lock.release()
        except:
            return None
        self.w("<ul>")
        for g in games:
            result_list = g.results
            g1=""
            g2=""
            rid=""
            if len(result_list):
                r = result_list[0]
                g1 = r.goals1
                g2 = r.goals2
                rid = r.id
            self.w("""
            <li>%(game_id)s) %(t1)s : %(t2)s
            <form method="post" action="">
                <input type="hidden" name="_action_update">
                <input type="hidden" name="game_id" value="%(game_id)s">
                <input type="text" name="goals1" size="2" value="%(g1)s"> :
                <input type="text" name="goals2" size="2" value="%(g2)s">
                <input type="submit" value="update">
            </form>
            <form method="post" action="">
                <input type="hidden" name="_action_delete">
                <input type="hidden" name="rid" value="%(rid)s">
                <input type="submit" value="delete result">
            </form>
            </li>
            """ % {"game_id": g.id, "t1": g.team1.name, "t2": g.team2.name, "g1": g1, "g2": g2, "rid": rid})
        self.w("</ul>")
                
    def writeContent(self):
        pass

    def delete(self):
        req    = self.request()
        rid = req.value("rid", '').strip()
        try:
            rid = int(rid)
            self.error = del_game_result(rid)
        except ValueError, e:
            self.error = e
        self.writeBody()
        
    
    def update(self):
        req    = self.request()
        game_id = req.value("game_id", '').strip()
        t1 = req.value("t1", '').strip()
        t2 = req.value("t2", '').strip()
        
        g1 = req.value("goals1", '').strip()
        g2 = req.value("goals2", '').strip()
        try:
            g1 = int(g1)
            g2 = int(g2)
        except ValueError, e:
            self.error = e
            self.writeBody()
            return
        
        # thsi could fails:
        g = game(game_id)
        add_game_result(g, g1, g2)
        self.writeBody()
        

    def actions(self):
        return Page.actions(self) + ["update", "delete", "login"]
