from __future__ import with_statement

import BaseHTTPServer
import select
import threading

import serverthread

normal_body = "This is some data.  Enjoy it.\n"
charset_bodies = {
    'us-ascii': "This is some US-ASCII data.  Enjoy it.\n",
    'utf8': u"This is some utf8 data.  Enjoy it.\n",
}

class MagicHandlerOfDoom(BaseHTTPServer.BaseHTTPRequestHandler):
    def do_GET(self):
        if self.path == '/vary':
            return self.do_vary()
        if self.path == '/loc':
            return self.do_loc(False)
        if self.path == '/cloc':
            return self.do_cloc(False)
        if self.path == '/absloc':
            return self.do_loc(True)
        if self.path == '/abscloc':
            return self.do_cloc(True)
        if self.path == '/hostcloc':
            return self.do_hostcloc()
        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.send_header('Cache-control', 'max-age=300')
        self.send_header('Content-length', len(normal_body))
        self.end_headers()
        self.wfile.write(normal_body)
    
    def do_PUT(self):
        if self.path == '/loc':
            self.send_response(302)
            self.send_header('Location', '/')
        elif self.path == '/absloc':
            self.send_response(302)
            self.send_header('Location', 'http://harfy.jeamland.net:8000/')
        else:
            self.send_response(200)
        self.send_header('Content-length', 0)
        self.end_headers()

    def do_POST(self):
        self.send_response(201)
        self.send_header('Location', 'http://harfy.jeamland.net:8000/posted')
        self.end_headers()
        
    do_FNORD = do_GET

    def do_vary(self):
        charset = self.headers.getheader('accept-charset', None)
        if charset is None or charset.lower() not in charset_bodies:
            charset = 'us-ascii'
        response_body = charset_bodies[charset]
        self.send_response(200)
        self.send_header('Content-type', 'text/plain; charset=%s' % charset)
        self.send_header('Cache-control', 'max-age=300')
        self.send_header('Content-length', len(response_body))
        self.send_header('Vary', 'Accept-Charset')
        self.end_headers()
        self.wfile.write(response_body)
    
    def do_loc(self, absolute):
        self.send_response(302)
        self.send_header('Cache-control', 'max-age=300')
        if absolute:
            self.send_header('Location', 'http://harfy.jeamland.net:8000/')
        else:
            self.send_header('Location', '/')
        self.end_headers()
        
    def do_cloc(self, absolute):
        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.send_header('Cache-control', 'max-age=300')
        self.send_header('Content-length', len(normal_body))
        if absolute:
            self.send_header('Content-location', 'http://harfy.jeamland.net:8000/')
        else:
            self.send_header('Content-location', '/')
        self.end_headers()
        self.wfile.write(normal_body)
    
    def do_hostcloc(self):
        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.send_header('Cache-control', 'max-age=300')
        self.send_header('Content-length', len(normal_body))
        self.send_header('Content-location', 'http://harfy.jeamland.net:8001/')
        self.end_headers()
        self.wfile.write(normal_body)

class ReusableHTTPServer(BaseHTTPServer.HTTPServer):
    allow_reuse_address = True
    
class HTTPServerThread(serverthread.ServerThread):
    def __init__(self, *args):
        super(HTTPServerThread, self).__init__(ReusableHTTPServer,
                                               MagicHandlerOfDoom, *args)
                
if __name__ == '__main__':
    import time
    
    thread = HTTPServerThread(('0.0.0.0', 8000))
    thread.start()
    
    try:
        while True:
            time.sleep(600)
    except:
        pass
    
    thread.quit = True
    thread.join()
