import select
import threading
import traceback

class ServerThread(threading.Thread):
    def __init__(self, server_class, handler_class, *args):
        super(ServerThread, self).__init__()
        self.servers = []
        for address in args:
            self.servers.append(server_class(address, handler_class))
        self.ready = threading.Event()
        self.quit = False

    def run(self):
        self.ready.set()
        while not self.quit:
            try:
                r, w, e = select.select(self.servers, [], [], 1.0)
                for server in r:
                    server.handle_request()
            except:
                traceback.print_exc()
                self.quit = True
