import os
import os.path
import signal
import subprocess
import time

class SquidController(object):
    def __init__(self, path="../src", bin='squid', args=['-NX']):
        self.bin_path = os.path.join(path, bin)
        self.def_args = args
        self.squid = None
    
    def start(self, args=None):
        if self.squid is not None:
            raise Exception('squid already running')
        if args is None:
            args = self.def_args
        self.squid = subprocess.Popen([self.bin_path] + args,
                                      stdout=file('/dev/null', 'w'),
                                      stderr=subprocess.STDOUT)
        time.sleep(1)
    
    def stop(self):
        os.kill(self.squid.pid, signal.SIGINT)
        count = 10
        while count > 0:
            if self.squid.poll() is not None:
                self.squid = None
                return
            time.sleep(1)
        os.kill(self.squid.pid, signal.SIGKILL)
        self.squid.wait()
        self.squid = None
    
    def restart(self, args=None):
        self.stop()
        self.start(args)
    
    def clear_cache(self, cache_path="../var/cache"):
        for dirpath, dirnames, filenames in os.walk(cache_path):
            for filename in filenames:
                os.remove(os.path.join(dirpath, filename))
        